/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.world.entity;

import com.stereowalker.unionlib.world.item.ItemFilters;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;

public enum AccessorySlot {
    NECK_1(ItemFilters.NECKLACES, 0, Group.NECK, "neck_1"),
    BACK_1(ItemFilters.BACK_ITEMS, 1, Group.BACK, "back_7"),
    BACK_2(ItemFilters.BACK_ITEMS, 2, Group.BACK, "back_2"),
    BACK_3(ItemFilters.BACK_ITEMS, 4, Group.BACK, "back_3"),
    BACK_4(ItemFilters.BACK_ITEMS, 5, Group.BACK, "back_4"),
    BACK_5(ItemFilters.BACK_ITEMS, 7, Group.BACK, "back_5"),
    BACK_6(ItemFilters.BACK_ITEMS, 8, Group.BACK, "back_6"),
    FINGER_1(ItemFilters.RINGS, 3, Group.FINGER, "finger_1"),
    FINGER_2(ItemFilters.RINGS, 6, Group.FINGER, "finger_2");

    Predicate<ItemStack> validStack;
    int index;
    String name;
    Group group;

    private AccessorySlot(Predicate<ItemStack> validStackIn, int index, Group group, String name) {
        this.validStack = validStackIn;
        this.index = index;
        this.name = name;
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public static AccessorySlot byName(String pTargetName) {
        for (AccessorySlot equipmentslot : AccessorySlot.values()) {
            if (!equipmentslot.getName().equals(pTargetName)) continue;
            return equipmentslot;
        }
        throw new IllegalArgumentException("Invalid slot '" + pTargetName + "'");
    }

    public static AccessorySlot byGroupAndIndex(Group pSlotType, int pSlotIndex) {
        for (AccessorySlot equipmentslot : AccessorySlot.values()) {
            if (equipmentslot.getGroup() != pSlotType || equipmentslot.getIndex() != pSlotIndex) continue;
            return equipmentslot;
        }
        throw new IllegalArgumentException("Invalid slot '" + String.valueOf((Object)pSlotType) + "': " + pSlotIndex);
    }

    public Group getGroup() {
        return this.group;
    }

    public Predicate<ItemStack> getValidStack() {
        return this.validStack;
    }

    public int getTextureIndex() {
        return this.group.ordinal();
    }

    public int getIndex() {
        return this.index;
    }

    public static enum Group {
        NECK("neck"),
        BACK("back"),
        FINGER("finger");

        String name;

        private Group(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Group byName(String pTargetName) {
            for (Group equipmentslot : Group.values()) {
                if (!equipmentslot.getName().equals(pTargetName)) continue;
                return equipmentslot;
            }
            throw new IllegalArgumentException("Invalid group '" + pTargetName + "'");
        }
    }
}

