/*
 * Decompiled with CFR 0.152.
 */
package com.aesefficio.interiors;

import com.aesefficio.interiors.Utils;
import com.aesefficio.interiors.content.registry.CIBlocks;
import com.aesefficio.interiors.content.registry.CIEntities;
import com.aesefficio.interiors.content.registry.CITab;
import com.aesefficio.interiors.content.registry.CITags;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.CreateBuildInfo;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.FilesHelper;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="interiors")
public final class CreateInteriors {
    public static final String ID = "interiors";
    public static final String NAME = "Create: Interiors";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create: Interiors");
    public static final String VERSION = Utils.getVersion("interiors");
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"interiors");

    public static void init() {
        LOGGER.info("{} v{} initializing! Create version: {} on platform: {}", new Object[]{NAME, VERSION, CreateBuildInfo.VERSION, Utils.platformName()});
        CITags.register();
        CIEntities.register();
        CIBlocks.register();
    }

    public CreateInteriors(IEventBus modBus) {
        REGISTRATE.registerEventListeners(modBus);
        CreateInteriors.init();
        CITab.register(modBus);
        modBus.addListener(this::gatherData);
    }

    public void gatherData(GatherDataEvent event) {
        CreateInteriors.provideDefaultLang("tooltips");
    }

    private static void provideDefaultLang(String fileName) {
        String path = "assets/interiors/lang/default/" + fileName + ".json";
        JsonObject jsonObject = ((JsonElement)Preconditions.checkNotNull((Object)FilesHelper.loadJsonResource((String)path), (String)"Could not find default lang file: %s", (Object)path)).getAsJsonObject();
        jsonObject.entrySet().forEach(entry -> REGISTRATE.addRawLang((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
    }

    public static ResourceLocation id(String path) {
        return Utils.id(ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE)).defaultCreativeTab((ResourceKey)null);
    }
}

