/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.IBlockGetter;
import de.mrjulsen.crn.block.properties.EBlockAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AdvancedDisplaySlabBlock
extends AbstractAdvancedSidedDisplayBlock {
    public static final EnumProperty<EBlockAlignment> Y_ALIGN = EnumProperty.create((String)"y_alignment", EBlockAlignment.class);
    private static final Map<ShapeKey, VoxelShape> SHAPES = Map.ofEntries(Map.entry(new ShapeKey(Direction.SOUTH, EBlockAlignment.NEGATIVE), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)), Map.entry(new ShapeKey(Direction.NORTH, EBlockAlignment.NEGATIVE), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)), Map.entry(new ShapeKey(Direction.EAST, EBlockAlignment.NEGATIVE), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)), Map.entry(new ShapeKey(Direction.WEST, EBlockAlignment.NEGATIVE), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)), Map.entry(new ShapeKey(Direction.SOUTH, EBlockAlignment.CENTER), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)), Map.entry(new ShapeKey(Direction.NORTH, EBlockAlignment.CENTER), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)), Map.entry(new ShapeKey(Direction.EAST, EBlockAlignment.CENTER), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)), Map.entry(new ShapeKey(Direction.WEST, EBlockAlignment.CENTER), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)), Map.entry(new ShapeKey(Direction.SOUTH, EBlockAlignment.POSITIVE), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.NORTH, EBlockAlignment.POSITIVE), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.EAST, EBlockAlignment.POSITIVE), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.WEST, EBlockAlignment.POSITIVE), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));

    public AdvancedDisplaySlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(Y_ALIGN, (Comparable)((Object)EBlockAlignment.CENTER)));
    }

    @Override
    public Collection<Property<?>> getExcludedProperties() {
        return List.of(Y_ALIGN);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(new ShapeKey((Direction)pState.getValue((Property)FACING), (EBlockAlignment)((Object)pState.getValue(Y_ALIGN))));
    }

    @Override
    public BlockState getDefaultPlacementState(BlockPlaceContext context, BlockState state, BlockState other) {
        BlockState stateForPlacement = super.getDefaultPlacementState(context, state, other);
        Direction direction = context.getClickedFace();
        EBlockAlignment yAlign = EBlockAlignment.CENTER;
        if (direction == Direction.UP || context.getClickLocation().y - (double)context.getClickedPos().getY() < 0.33333333) {
            yAlign = EBlockAlignment.NEGATIVE;
        } else if (direction == Direction.DOWN || context.getClickLocation().y - (double)context.getClickedPos().getY() > 0.66666666) {
            yAlign = EBlockAlignment.POSITIVE;
        }
        return (BlockState)stateForPlacement.setValue(Y_ALIGN, (Comparable)((Object)yAlign));
    }

    @Override
    public BlockState appendOnPlace(BlockPlaceContext context, BlockState state, BlockState other) {
        return (BlockState)super.appendOnPlace(context, state, other).setValue(Y_ALIGN, (Comparable)((Object)((EBlockAlignment)((Object)other.getValue(Y_ALIGN)))));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.add(new Property[]{Y_ALIGN}));
    }

    @Override
    public boolean canConnectWithBlock(IBlockGetter level, BlockState selfState, BlockState otherState) {
        return super.canConnectWithBlock(level, selfState, otherState) && selfState.getValue(Y_ALIGN) == otherState.getValue(Y_ALIGN);
    }

    @Override
    protected boolean canConnect(LevelAccessor level, BlockPos pos, BlockState state, BlockState other) {
        return super.canConnect(level, pos, state, other) && state.getValue(Y_ALIGN) == other.getValue(Y_ALIGN);
    }

    @Override
    public Pair<Float, Float> getRenderAspectRatio(Level level, BlockState blockState, BlockPos pos) {
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.5f));
    }

    @Override
    public Pair<Float, Float> getRenderOffset(Level level, BlockState blockState, BlockPos pos) {
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(switch ((EBlockAlignment)((Object)blockState.getValue(Y_ALIGN))) {
            case EBlockAlignment.NEGATIVE -> 8.0f;
            case EBlockAlignment.POSITIVE -> 0.0f;
            default -> 4.0f;
        }));
    }

    @Override
    public Pair<Float, Float> getRenderZOffset(Level level, BlockState blockState, BlockPos pos) {
        return Pair.of((Object)Float.valueOf(16.05f), (Object)Float.valueOf(16.05f));
    }

    @Override
    public Tripple<Float, Float, Float> getRenderRotation(Level level, BlockState blockState, BlockPos pos) {
        return Tripple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    }

    @Override
    public boolean isSingleLined() {
        return true;
    }

    private static final class ShapeKey {
        private final Direction facing;
        private final EBlockAlignment yAlign;

        public ShapeKey(Direction facing, EBlockAlignment yAlign) {
            this.facing = facing;
            this.yAlign = yAlign;
        }

        public boolean equals(Object o) {
            if (o instanceof ShapeKey) {
                ShapeKey other = (ShapeKey)o;
                return this.facing == other.facing && this.yAlign == other.yAlign;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.facing, this.yAlign});
        }
    }
}

