/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber;

import com.mojang.math.Axis;
import de.mrjulsen.crn.block.TrainStationClockBlock;
import de.mrjulsen.crn.block.blockentity.TrainStationClockBlockEntity;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.AbstractBlockEntityRenderInstance;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class TrainStationClockRenderer
extends AbstractBlockEntityRenderInstance<TrainStationClockBlockEntity> {
    private static final ResourceLocation DIAL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"textures/block/dial.png");

    public TrainStationClockRenderer(TrainStationClockBlockEntity blockEntity) {
        super((BlockEntity)blockEntity);
    }

    public void render(BERGraphics<TrainStationClockBlockEntity> graphics, float partialTick) {
        BERUtils.initRenderEngine();
        graphics.poseStack().pushPose();
        this.renderInternal(graphics, partialTick);
        graphics.poseStack().popPose();
        if (((Boolean)((TrainStationClockBlockEntity)graphics.blockEntity()).getBlockState().getValue((Property)TrainStationClockBlock.DOUBLE)).booleanValue()) {
            graphics.poseStack().pushPose();
            graphics.poseStack().translate(8.0f, 8.0f, 8.0f);
            graphics.poseStack().mulPose(Axis.YP.rotationDegrees(90.0f));
            graphics.poseStack().translate(-8.0f, -8.0f, -8.0f);
            this.renderInternal(graphics, partialTick);
            graphics.poseStack().popPose();
        }
    }

    private void renderInternal(BERGraphics<TrainStationClockBlockEntity> graphics, float partialTicks) {
        float z = (Boolean)((TrainStationClockBlockEntity)graphics.blockEntity()).getBlockState().getValue((Property)TrainStationClockBlock.DOUBLE) != false ? 7.25f : 3.25f;
        graphics.poseStack().translate(8.0f, 8.0f, 8.0f + z);
        BERUtils.renderTexture((ResourceLocation)DIAL_TEXTURE, graphics, (!((TrainStationClockBlockEntity)graphics.blockEntity()).isGlowing() ? 1 : 0) != 0, (float)-7.0f, (float)-7.0f, (float)-0.2f, (float)14.0f, (float)14.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)((Direction)((TrainStationClockBlockEntity)graphics.blockEntity()).getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)), (int)(0xFF000000 | ((TrainStationClockBlockEntity)graphics.blockEntity()).getColor()), (int)(((TrainStationClockBlockEntity)graphics.blockEntity()).isGlowing() ? 0xF000F0 : graphics.packedLight()));
        graphics.poseStack().pushPose();
        graphics.poseStack().mulPose(Axis.ZP.rotationDegrees(-90.0f + ModUtils.clockHandDegrees(((TrainStationClockBlockEntity)graphics.blockEntity()).getLevel().getDayTime() + DragonLib.daytimeShift(), 12000)));
        BERUtils.fillColor(graphics, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)6.0f, (float)1.0f, (int)-15132391, (Direction)((Direction)((TrainStationClockBlockEntity)graphics.blockEntity()).getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)));
        graphics.poseStack().popPose();
        graphics.poseStack().pushPose();
        graphics.poseStack().mulPose(Axis.ZP.rotationDegrees(-90.0f + ModUtils.clockHandDegrees(((TrainStationClockBlockEntity)graphics.blockEntity()).getLevel().getDayTime() + DragonLib.daytimeShift(), 1000)));
        BERUtils.fillColor(graphics, (float)-0.5f, (float)-0.5f, (float)0.1f, (float)7.0f, (float)1.0f, (int)-14540254, (Direction)((Direction)((TrainStationClockBlockEntity)graphics.blockEntity()).getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)));
        graphics.poseStack().popPose();
        graphics.poseStack().translate(0.0f, 0.0f, -z * 2.0f);
        graphics.poseStack().pushPose();
        graphics.poseStack().mulPose(Axis.YP.rotationDegrees(180.0f));
        BERUtils.renderTexture((ResourceLocation)DIAL_TEXTURE, graphics, (!((TrainStationClockBlockEntity)graphics.blockEntity()).isGlowing() ? 1 : 0) != 0, (float)-7.0f, (float)-7.0f, (float)-0.2f, (float)14.0f, (float)14.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)((Direction)((TrainStationClockBlockEntity)graphics.blockEntity()).getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite(), (int)(0xFF000000 | ((TrainStationClockBlockEntity)graphics.blockEntity()).getColor()), (int)(((TrainStationClockBlockEntity)graphics.blockEntity()).isGlowing() ? 0xF000F0 : graphics.packedLight()));
        graphics.poseStack().popPose();
        graphics.poseStack().pushPose();
        graphics.poseStack().mulPose(Axis.ZN.rotationDegrees(-90.0f + ModUtils.clockHandDegrees(((TrainStationClockBlockEntity)graphics.blockEntity()).getLevel().getDayTime() + DragonLib.daytimeShift(), 12000)));
        graphics.poseStack().mulPose(Axis.YP.rotationDegrees(180.0f));
        BERUtils.fillColor(graphics, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)6.0f, (float)1.0f, (int)-15132391, (Direction)((Direction)((TrainStationClockBlockEntity)graphics.blockEntity()).getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)));
        graphics.poseStack().popPose();
        graphics.poseStack().pushPose();
        graphics.poseStack().mulPose(Axis.ZN.rotationDegrees(-90.0f + ModUtils.clockHandDegrees(((TrainStationClockBlockEntity)graphics.blockEntity()).getLevel().getDayTime() + DragonLib.daytimeShift(), 1000)));
        graphics.poseStack().mulPose(Axis.YP.rotationDegrees(180.0f));
        BERUtils.fillColor(graphics, (float)-0.5f, (float)-0.5f, (float)0.1f, (float)7.0f, (float)1.0f, (int)-14540254, (Direction)((Direction)((TrainStationClockBlockEntity)graphics.blockEntity()).getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)));
        graphics.poseStack().popPose();
    }
}

