/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.SimpleStaticTextDisplaySettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.util.VariableManager;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERStaticText
implements AbstractAdvancedDisplayRenderer<SimpleStaticTextDisplaySettings> {
    private final BERLabel label = new BERLabel().setScrollingSpeed(2.0f).setYScale(0.75f).setScale(0.75f, 0.5f).setPos(3.0f, 5.2f).setCentered(true).setText((Component)TextUtils.empty());

    @Override
    public void renderTick(float deltaTime) {
        this.label.renderTick();
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        MutableComponent text = this.getText(((SimpleStaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getStaticText());
        this.label.setText((Component)text);
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        this.label.render(graphics, light);
    }

    private MutableComponent getText(String input) {
        String staticText = VariableManager.replacePlaceholders(input);
        MutableComponent text = TextUtils.empty();
        if (staticText != null) {
            try {
                text = Component.Serializer.fromJson((String)staticText, (HolderLookup.Provider)RegistryAccess.EMPTY);
            }
            catch (Exception e) {
                text = TextUtils.text((String)staticText);
            }
        }
        if (text == null) {
            text = TextUtils.empty();
        }
        return text;
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (!blockEntity.isController()) {
            return;
        }
        MutableComponent text = this.getText(((SimpleStaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getStaticText());
        this.label.setColor(0xFF000000 | ((SimpleStaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF).setText((Component)text).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 3) - this.label.getX(), BERLabel.BoundsHitReaction.SCALE_SCROLL);
    }
}

