/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class NavigatorToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/system");
    private static final long DISPLAY_TIME = 5000L;
    private static final int MAX_LINE_SIZE = 200;
    private static final ResourceLocation MOD_ICON = ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"textures/mod_icon.png");
    private static final int COLOR_BORDER = -16777216;
    private static final int COLOR_INNER_BORDER = -14130043;
    private static final int COLOR_CANVAS = -16241588;
    private Component title;
    private List<FormattedCharSequence> messageLines;
    private long lastChanged;
    private boolean changed;
    private final int width;

    public NavigatorToast(Component pTitle, Component pMessage) {
        this(pTitle, (List<FormattedCharSequence>)NavigatorToast.nullToEmpty(pMessage), Math.max(160, 30 + Math.max(Minecraft.getInstance().font.width((FormattedText)pTitle), pMessage == null ? 0 : Minecraft.getInstance().font.width((FormattedText)pMessage))));
    }

    public static NavigatorToast multiline(Component pTitle, Component pMessage) {
        Font font = Minecraft.getInstance().font;
        List list = font.split((FormattedText)pMessage, 200);
        int lineWidth = Math.max(Math.max(200, font.width((FormattedText)pTitle)), list.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(200));
        return new NavigatorToast(pTitle, list, lineWidth + 48);
    }

    private NavigatorToast(Component pTitle, List<FormattedCharSequence> pMessageLines, int pWidth) {
        this.title = pTitle;
        this.messageLines = pMessageLines;
        this.width = pWidth;
    }

    private static ImmutableList<FormattedCharSequence> nullToEmpty(Component pMessage) {
        return pMessage == null ? ImmutableList.of() : ImmutableList.of((Object)pMessage.getVisualOrderText());
    }

    public int width() {
        return this.width;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        if (this.changed) {
            this.lastChanged = pTimeSinceLastVisible;
            this.changed = false;
        }
        Graphics graphics = new Graphics(guiGraphics, guiGraphics.pose());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_SPRITE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int lineWidth = this.width;
        int lineHeight = 10;
        int toastHeight = this.height() + Math.max(0, this.messageLines.size() - 1) * lineHeight + 3;
        GuiUtils.fill((Graphics)graphics, (int)0, (int)0, (int)lineWidth, (int)toastHeight, (int)-16777216);
        GuiUtils.fill((Graphics)graphics, (int)1, (int)1, (int)(lineWidth - 2), (int)(toastHeight - 2), (int)-14130043);
        GuiUtils.fill((Graphics)graphics, (int)3, (int)3, (int)(lineWidth - 6), (int)(toastHeight - 6), (int)-16241588);
        GuiUtils.drawTexture((ResourceLocation)MOD_ICON, (Graphics)graphics, (int)4, (int)(this.messageLines == null || this.messageLines.size() <= 1 ? 0 : 4), (int)32, (int)32, (int)0, (int)0, (int)64, (int)64, (int)64, (int)64);
        if (this.messageLines == null) {
            GuiUtils.drawString((Graphics)graphics, (Font)pToastComponent.getMinecraft().font, (int)40, (int)lineHeight, (FormattedText)this.title, (int)-256, (EAlignment)EAlignment.LEFT, (boolean)false);
        } else {
            GuiUtils.drawString((Graphics)graphics, (Font)pToastComponent.getMinecraft().font, (int)40, (int)7, (FormattedText)this.title, (int)-256, (EAlignment)EAlignment.LEFT, (boolean)false);
            for (int i = 0; i < this.messageLines.size(); ++i) {
                graphics.graphics().drawString(Minecraft.getInstance().font, this.messageLines.get(i), 40, 20 + i * lineHeight, -1, false);
            }
        }
        return pTimeSinceLastVisible - this.lastChanged < 5000L ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }
}

