/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import de.mrjulsen.crn.client.ModGuiUtils;
import de.mrjulsen.crn.client.gui.Animator;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.RouteDetailsScreen;
import de.mrjulsen.crn.client.gui.widgets.RouteViewer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.SavedRoutesManager;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ITickable;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class RouteWidget
extends DLButton
implements ITickable {
    public static final int WIDTH = 214;
    public static final int HEIGHT = 54;
    private static final int DISPLAY_WIDTH = 204;
    private final ClientRoute route;
    private final MutableComponent transferText = CustomLanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.transfer");
    private final MutableComponent connectionInPast = CustomLanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.connection_in_past");
    private final MutableComponent trainCanceled = CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.stop_cancelled");
    private final MutableComponent textShowDetails = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.show_details");
    private final MutableComponent textSave = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.save");
    private final MutableComponent textShare = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.share");
    private final MutableComponent textRemove = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.remove");
    private final Animator animator = new Animator();

    public RouteWidget(RouteViewer parent, ClientRoute route, int x, int y) {
        super(x, y, 214, 54, (Component)TextUtils.empty(), b -> {
            route.addListener();
            Minecraft.getInstance().setScreen((Screen)new RouteDetailsScreen(parent.getParent(), route));
            route.close();
        });
        this.route = route;
        this.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
        this.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((AbstractWidget)this), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((Component)this.textShowDetails, Sprite.empty(), true, b -> this.onPress.onPress((Button)b), null)).addSeparator().add(new DLContextMenuItem.ContextMenuItemData((Component)(SavedRoutesManager.isSaved(route) ? this.textRemove : this.textSave), Sprite.empty(), true, b -> {
            if (SavedRoutesManager.isSaved(route)) {
                SavedRoutesManager.removeRoute(route);
            } else {
                SavedRoutesManager.saveRoute(route);
            }
        }, null))));
        this.animator.start(10, null, null, null);
    }

    public void tick() {
        this.animator.tick();
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int color;
        int i;
        this.animator.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        graphics.poseStack().pushPose();
        if (this.animator.isRunning()) {
            graphics.poseStack().translate(-(50.0 * Math.pow(1.0 - (double)this.animator.getPercentage(), 4.0)), 0.0, 0.0);
        }
        int precision = (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get();
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x(), this.y(), 214, 54, CreateDynamicWidgets.ColorShade.DARK.getColor());
        CreateDynamicWidgets.renderHorizontalSeparator(graphics, this.x() + 6, this.y() + 22, 202);
        if (this.isMouseSelected()) {
            GuiUtils.fill((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.width(), (int)this.height(), (int)0x22FFFFFF);
        }
        Minecraft minecraft = Minecraft.getInstance();
        ImmutableList<RoutePart> parts = this.route.getParts();
        NoShadowFontWrapper shadowlessFont = new NoShadowFontWrapper(minecraft.font);
        String timeStart = TimeUtils.parseTime((long)((int)((this.route.getStart().getScheduledDepartureTime() + DragonLib.daytimeShift()) % DragonLib.ticksPerDay())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        String timeEnd = TimeUtils.parseTime((long)((int)((this.route.getEnd().getScheduledArrivalTime() + DragonLib.daytimeShift()) % DragonLib.ticksPerDay())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        String dash = " - ";
        MutableComponent summary = TextUtils.text((String)String.format("%s%s%s | %s %s | %s", timeStart, dash, timeEnd, this.route.getTransferCount(), this.transferText.getString(), TimeUtils.parseDurationShort((long)((int)this.route.travelTime()))));
        float scale = 0.75f;
        float localScale = shadowlessFont.width((FormattedText)summary) > 202 ? 0.75f : 1.0f;
        graphics.poseStack().pushPose();
        graphics.poseStack().scale(localScale, 1.0f, 1.0f);
        GuiUtils.drawString((Graphics)graphics, (Font)minecraft.font, (int)((int)((float)(this.x() + 6) / localScale)), (int)(this.y() + 5), (FormattedText)summary, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().popPose();
        int routePartWidth = 204 / parts.size();
        String endStationName = this.route.getEnd().getRealTimeStationTag().tagName();
        int textW = shadowlessFont.width(endStationName);
        for (i = 0; i < parts.size(); ++i) {
            color = ((RoutePart)parts.get(i)).getFirstStop().getTrainDisplayColor();
            GuiUtils.fill((Graphics)graphics, (int)(this.x() + 6 + i * routePartWidth + 1), (int)(this.y() + 27), (int)(routePartWidth - 4), (int)1, (int)color);
            GuiUtils.fill((Graphics)graphics, (int)(this.x() + 5 + i * routePartWidth + 1), (int)(this.y() + 28), (int)(routePartWidth - 2), (int)9, (int)color);
            GuiUtils.fill((Graphics)graphics, (int)(this.x() + 6 + i * routePartWidth + 1), (int)(this.y() + 37), (int)(routePartWidth - 4), (int)1, (int)color);
        }
        graphics.poseStack().pushPose();
        graphics.poseStack().scale(0.75f, 0.75f, 0.75f);
        for (i = 0; i < parts.size(); ++i) {
            color = ((RoutePart)parts.get(i)).getFirstStop().getTrainDisplayColor();
            int fontColor = ModGuiUtils.useWhiteOrBlackForeColor(color) ? -1 : -16777216;
            Component trainName = GuiUtils.ellipsisString((Font)this.font, (Component)TextUtils.text((String)((RoutePart)parts.get(i)).getFirstStop().getTrainDisplayName()), (int)((int)((float)(routePartWidth - 10) / 0.75f)));
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)((float)(this.x() + 5 + i * routePartWidth + routePartWidth / 2) / 0.75f)), (int)((int)((float)(this.y() + 30) / 0.75f)), (FormattedText)trainName, (int)fontColor, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)((float)(this.x() + 6) / 0.75f)), (int)((int)((float)(this.y() + 43) / 0.75f)), (FormattedText)TextUtils.text((String)this.route.getStart().getRealTimeStationTag().tagName()), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)((float)(this.x() + 214 - 6) / 0.75f) - textW), (int)((int)((float)(this.y() + 43) / 0.75f)), (FormattedText)TextUtils.text((String)endStationName), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        if (this.route.getStart().shouldRenderRealTime()) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)(((float)(this.x() + 6) + (float)this.font.width(timeStart) * localScale / 2.0f) / 0.75f) - this.font.width(timeStart) / 2), (int)((int)((float)(this.y() + 15) / 0.75f)), (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)((int)((this.route.getStart().getScheduledDepartureTime() + this.route.getStart().getDepartureTimeDeviation() / (long)precision * (long)precision) % 24000L + DragonLib.daytimeShift())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(this.route.getStart().isDepartureDelayed() ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        if (this.route.getEnd().shouldRenderRealTime()) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)(((float)(this.x() + 6) + (float)this.font.width(timeEnd) * localScale * 1.5f + (float)this.font.width(dash) * localScale) / 0.75f) - this.font.width(timeEnd) / 2), (int)((int)((float)(this.y() + 15) / 0.75f)), (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)((int)((this.route.getEnd().getScheduledArrivalTime() + this.route.getEnd().getArrivalTimeDeviation() / (long)precision * (long)precision) % 24000L + DragonLib.daytimeShift())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(this.route.getEnd().isArrivalDelayed() ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        if (this.route.isAnyCancelled()) {
            GuiUtils.drawString((Graphics)graphics, (Font)shadowlessFont, (int)((int)((float)(this.x() + 214 - 5) / 0.75f)), (int)((int)((float)(this.y() + 15) / 0.75f)), (FormattedText)this.trainCanceled, (int)-48574, (EAlignment)EAlignment.RIGHT, (boolean)false);
        } else if (this.route.getStart().isDeparted()) {
            GuiUtils.drawString((Graphics)graphics, (Font)shadowlessFont, (int)((int)((float)(this.x() + 214 - 5) / 0.75f)), (int)((int)((float)(this.y() + 15) / 0.75f)), (FormattedText)this.connectionInPast, (int)-48574, (EAlignment)EAlignment.RIGHT, (boolean)false);
        }
        graphics.poseStack().popPose();
        graphics.poseStack().popPose();
    }
}

