/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import com.google.common.collect.ImmutableMap;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.options.AbstractDataListEntry;
import de.mrjulsen.crn.client.gui.widgets.options.DataListContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class SimpleDataListNewEntry<T, S>
extends AbstractDataListEntry<T, S, InputDataSectionDefinition<T, S>> {
    public static final String MAIN_INPUT_KEY = "name";
    public Map<String, Supplier<String>> values = new HashMap<String, Supplier<String>>();
    private Consumer<DLEditBox> onCreateMainEditBox;
    private Function<DLEditBox, Component> onSetNameEditBoxTooltip;

    public SimpleDataListNewEntry(DataListContainer<T, S> parent, int x, int y, int width) {
        super(parent, x, y, width, null);
    }

    public void addDataSection(int width, String key, Component text, Consumer<DLEditBox> onCreateEditBox) {
        this.createSection(new InputDataSectionDefinition(this.getCurrentSectionsXOffset(), width, key, text, onCreateEditBox));
    }

    public void addAddButton(Sprite icon, List<FormattedText> description, DataListAddNewEntryContext<DLIconButton, T> onClick) {
        this.addButton(icon, description, (btn, data, entry, refreshAction) -> {
            if (onClick.run((DLIconButton)btn, this.parent.getData(), (ImmutableMap<String, Supplier<String>>)ImmutableMap.copyOf(this.values), refreshAction)) {
                this.children().stream().filter(x -> x instanceof EditBox).map(x -> (EditBox)x).forEach(x -> x.setValue(""));
            }
        });
    }

    public void editNameEditBox(Consumer<DLEditBox> onCreateMainEditBox) {
        this.onCreateMainEditBox = onCreateMainEditBox;
    }

    public void setNameEditBoxTooltip(Function<DLEditBox, Component> onSetNameEditBoxTooltip) {
        this.onSetNameEditBoxTooltip = onSetNameEditBoxTooltip;
    }

    @Override
    protected void build() {
        this.values.clear();
        for (InputDataSectionDefinition section : this.getSections()) {
            int xCoord = this.x() + this.width() - 0 - 3 - this.getCurrentButtonsXOffset() - section.xOffset - section.width;
            DLEditBox inputBox = (DLEditBox)this.addRenderableWidget((GuiEventListener)new DLEditBox(this.font, xCoord + 4, this.y() + 5, section.width - 8, this.height() - 10, (Component)TextUtils.empty()));
            inputBox.setValue("");
            inputBox.setBordered(false);
            DLUtils.doIfNotNull(section.onCreateEditBox, x -> x.accept(inputBox));
            this.values.put(section.key, () -> inputBox.getValue());
            DLTooltip tooltip = DLTooltip.of((FormattedText)section.text).assignedTo((AbstractWidget)inputBox);
            tooltip.setDynamicOffset(() -> (int)this.parent.getParentEntry().getParentList().getXScrollOffset(), () -> (int)this.parent.getParentEntry().getParentList().getYScrollOffset());
            this.parent.getTooltips().add(tooltip);
        }
        int remainingWidth = this.width() - 0 - 0 - 3 - this.getCurrentButtonsXOffset() - this.getCurrentSectionsXOffset();
        int xCoord = this.x() + 0;
        DLEditBox inputBox = (DLEditBox)this.addRenderableWidget((GuiEventListener)new DLEditBox(this.font, xCoord + 4, this.y() + 5, remainingWidth - 8, this.height() - 10, (Component)TextUtils.empty()));
        inputBox.setValue("");
        inputBox.setBordered(false);
        DLUtils.doIfNotNull(this.onCreateMainEditBox, x -> x.accept(inputBox));
        DLUtils.doIfNotNull(this.onSetNameEditBoxTooltip, x -> {
            Component text = (Component)x.apply(inputBox);
            DLTooltip tooltip = DLTooltip.of((FormattedText)text).assignedTo((AbstractWidget)inputBox);
            tooltip.setDynamicOffset(() -> (int)this.parent.getParentEntry().getParentList().getXScrollOffset(), () -> (int)this.parent.getParentEntry().getParentList().getYScrollOffset());
            this.parent.getTooltips().add(tooltip);
        });
        this.values.put(MAIN_INPUT_KEY, () -> inputBox.getValue());
    }

    @Override
    protected void renderWidgetBase(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    protected void renderSection(Graphics graphics, int mouseX, int mouseY, float partialTicks, InputDataSectionDefinition<T, S> section, GuiAreaDefinition area) {
        CreateDynamicWidgets.renderTextBox(graphics, area.getX(), area.getY(), area.getWidth());
    }

    @Override
    protected void renderMainSection(Graphics graphics, int mouseX, int mouseY, float partialTicks, String text, GuiAreaDefinition area) {
        CreateDynamicWidgets.renderTextBox(graphics, area.getX(), area.getY(), area.getWidth());
    }

    public static class InputDataSectionDefinition<T, S>
    extends AbstractDataListEntry.AbstractDataSectionDefinition<T, S> {
        private final String key;
        private final Component text;
        private final Consumer<DLEditBox> onCreateEditBox;

        public InputDataSectionDefinition(int xOffset, int width, String key, Component text, Consumer<DLEditBox> onCreateEditBox) {
            super(xOffset, width);
            this.key = key;
            this.text = text;
            this.onCreateEditBox = onCreateEditBox;
        }
    }

    @FunctionalInterface
    public static interface DataListAddNewEntryContext<B extends DLButton, T> {
        public boolean run(B var1, T var2, ImmutableMap<String, Supplier<String>> var3, Consumer<Optional<T>> var4);
    }
}

