/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import de.mrjulsen.crn.api.IPredictableWaitCondition;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DynamicDelayCondition
extends ScheduledDelay
implements IPredictableWaitCondition {
    public static final String NBT_MIN = "Min";

    public DynamicDelayCondition() {
        this.data.putInt(NBT_MIN, 5);
    }

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)new ItemStack((ItemLike)Items.COMPARATOR), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + this.getId().getPath() + ".title"), (Object[])new Object[]{this.formatCustomTime(this.getMinValue(), true), this.formatTime(true)}));
    }

    protected Component formatCustomTime(int time, boolean compact) {
        if (compact) {
            return TextUtils.text((String)(time + this.getUnit().suffix));
        }
        return TextUtils.text((String)(time + " ")).append((Component)CreateLang.translateDirect((String)this.getUnit().key, (Object[])new Object[0]));
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().getPath())), (Object)CreateLang.translateDirect((String)"schedule.condition.for_x_time", (Object[])new Object[]{this.formatTime(false)}).withStyle(ChatFormatting.DARK_AQUA), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().getPath() + ".at_least"), (Object[])new Object[]{this.formatCustomTime(this.getMinValue(), false)}).withStyle(ChatFormatting.DARK_AQUA));
    }

    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        int time = context.getInt("Time");
        AtomicLong currentDelay = new AtomicLong(0L);
        AtomicLong scheduledDepartureTime = new AtomicLong(0L);
        AtomicBoolean initialized = new AtomicBoolean(false);
        TrainListener.getTrainData(train.id).ifPresent(data -> {
            Optional<TrainPrediction> pred = data.getNextStopPrediction();
            if (pred.isPresent()) {
                currentDelay.set(pred.get().getArrivalTimeDeviation());
                initialized.set(data.isInitialized() && !data.isPreInitializationPhase());
                scheduledDepartureTime.set(pred.get().scheduled().departureTime());
            }
        });
        long totalTicks = initialized.get() ? Math.max((long)this.totalWaitTicks() - currentDelay.get(), (long)this.minWaitTicks()) : (long)this.totalWaitTicks();
        if (!((long)time < (initialized.get() ? Math.max((long)this.totalWaitTicks() - currentDelay.get(), (long)this.minWaitTicks()) : (long)this.totalWaitTicks()) || initialized.get() && DragonLib.getCurrentWorldTime() < scheduledDepartureTime.get())) {
            return true;
        }
        context.putInt("Time", time + 1);
        context.putLong("TotalTicks", Math.max(totalTicks, scheduledDepartureTime.get() - DragonLib.getCurrentWorldTime() + (long)time));
        this.requestDisplayIfNecessary(context, time);
        return false;
    }

    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"dynamic_delay");
    }

    public int getMinValue() {
        return this.intData(NBT_MIN);
    }

    public int minWaitTicks() {
        return this.getMinValue() * this.getUnit().ticksPer;
    }

    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initDynamicDelayCondition(this, builder);
    }

    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        int time = tag.getInt("Time");
        long totalTime = tag.getInt("TotalTicks");
        long ticksUntilDeparture = Math.max(totalTime - (long)time, 0L);
        boolean showInMinutes = ticksUntilDeparture >= 1200L;
        int num = (int)(showInMinutes ? Math.floor((float)ticksUntilDeparture / 1200.0f) : Math.ceil((float)ticksUntilDeparture / 100.0f) * 5.0);
        String key = "generic." + (showInMinutes ? (num == 1 ? "daytime.minute" : "unit.minutes") : (num == 1 ? "daytime.second" : "unit.seconds"));
        return CreateLang.translateDirect((String)("schedule.condition." + this.getId().getPath() + ".status"), (Object[])new Object[]{TextUtils.text((String)(num + " ")).append((Component)CreateLang.translateDirect((String)key, (Object[])new Object[0]))});
    }

    @Override
    public long waitUntil(long worldTime) {
        return worldTime + (long)this.totalWaitTicks();
    }

    @Override
    public long waitMinUntil(long worldTime) {
        return worldTime + (long)this.minWaitTicks();
    }
}

