/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;

public class LockedList<T>
extends ArrayList<T> {
    private boolean locked;

    private void lock() {
        while (this.locked) {
        }
        this.locked = true;
    }

    private void unlock() {
        this.locked = false;
    }

    @Override
    public boolean add(T e) {
        this.lock();
        boolean b = super.add(e);
        this.unlock();
        return b;
    }

    @Override
    public void add(int index, T element) {
        this.lock();
        super.add(index, element);
        this.unlock();
    }

    @Override
    public boolean remove(Object o) {
        this.lock();
        boolean b = super.remove(o);
        this.unlock();
        return b;
    }

    @Override
    public void clear() {
        this.lock();
        super.clear();
        this.unlock();
    }

    @Override
    public T get(int index) {
        this.lock();
        Object t = super.get(index);
        this.unlock();
        return (T)t;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock();
        boolean b = super.retainAll(c);
        this.unlock();
        return b;
    }

    @Override
    public Stream<T> stream() {
        this.lock();
        Stream s = super.stream();
        this.unlock();
        return s;
    }
}

