/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.group.GroupList;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideGroupHudTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GroupScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/gui_group.png");
    protected static final ResourceLocation LEAVE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/leave.png");
    protected static final ResourceLocation MICROPHONE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone_button.png");
    protected static final ResourceLocation SPEAKER = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker_button.png");
    protected static final ResourceLocation GROUP_HUD = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/group_hud_button.png");
    protected static final Component TITLE = Component.translatable((String)"gui.voicechat.group.title");
    protected static final Component LEAVE_GROUP = Component.translatable((String)"message.voicechat.leave_group");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected GroupList groupList;
    protected int units;
    protected final ClientGroup group;
    protected ToggleImageButton mute;
    protected ToggleImageButton disable;
    protected ToggleImageButton showHUD;
    protected ImageButton leave;

    public GroupScreen(ClientGroup group) {
        super(TITLE, 236, 0);
        this.group = group;
    }

    @Override
    protected void init() {
        super.init();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.ceil((float)2.2222223f);
        this.units = Math.max(minUnits, (this.height - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();
        if (this.groupList != null) {
            this.groupList.updateSize(this.width, this.units * 18, 0, this.guiTop + 16);
        } else {
            this.groupList = new GroupList(this, this.width, this.units * 18, this.guiTop + 16, 36);
        }
        this.addWidget((GuiEventListener)this.groupList);
        int buttonY = this.guiTop + this.ySize - 20 - 7;
        int buttonSize = 20;
        this.mute = new ToggleImageButton(this.guiLeft + 7, buttonY, MICROPHONE, stateManager::isMuted, button -> stateManager.setMuted(!stateManager.isMuted()), new MuteTooltipSupplier(this, stateManager));
        this.addRenderableWidget((GuiEventListener)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 7 + buttonSize + 3, buttonY, SPEAKER, stateManager::isDisabled, button -> stateManager.setDisabled(!stateManager.isDisabled()), new DisableTooltipSupplier(this, stateManager));
        this.addRenderableWidget((GuiEventListener)this.disable);
        this.showHUD = new ToggleImageButton(this.guiLeft + 7 + (buttonSize + 3) * 2, buttonY, GROUP_HUD, VoicechatClient.CLIENT_CONFIG.showGroupHud::get, button -> VoicechatClient.CLIENT_CONFIG.showGroupHud.set(VoicechatClient.CLIENT_CONFIG.showGroupHud.get() == false).save(), new HideGroupHudTooltipSupplier(this));
        this.addRenderableWidget((GuiEventListener)this.showHUD);
        this.leave = new ImageButton(this.guiLeft + this.xSize - buttonSize - 7, buttonY, LEAVE, button -> {
            ClientServerNetManager.sendToServer(new LeaveGroupPacket());
            this.minecraft.setScreen((Screen)new JoinGroupScreen());
        });
        this.leave.setTooltip(Tooltip.create((Component)LEAVE_GROUP));
        this.addRenderableWidget((GuiEventListener)this.leave);
        this.checkButtons();
    }

    public void tick() {
        super.tick();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.active = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE);
        this.showHUD.active = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        guiGraphics.blit(TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        MutableComponent title = this.group.getType().equals(Group.Type.NORMAL) ? Component.translatable((String)"message.voicechat.group_title", (Object[])new Object[]{Component.literal((String)this.group.getName())}) : Component.translatable((String)"message.voicechat.group_type_title", (Object[])new Object[]{Component.literal((String)this.group.getName()), GroupType.fromType(this.group.getType()).getTranslation()});
        guiGraphics.drawString(this.font, (Component)title, this.guiLeft + this.xSize / 2 - this.font.width((FormattedText)title) / 2, this.guiTop + 5, 0x404040, false);
        this.groupList.render(guiGraphics, mouseX, mouseY, delta);
    }
}

