/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.onboarding;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.onboarding.IntroductionOnboardingScreen;
import de.maxhenkel.voicechat.voice.client.ChatUtils;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class OnboardingManager {
    private static final Minecraft MC = Minecraft.getInstance();

    public static boolean isOnboarding() {
        return VoicechatClient.CLIENT_CONFIG.onboardingFinished.get() == false;
    }

    public static void startOnboarding(@Nullable Screen parent) {
        MC.setScreen(OnboardingManager.getOnboardingScreen(parent));
    }

    public static Screen getOnboardingScreen(@Nullable Screen parent) {
        return new IntroductionOnboardingScreen(parent);
    }

    public static void finishOnboarding() {
        VoicechatClient.CLIENT_CONFIG.muted.set(true).save();
        VoicechatClient.CLIENT_CONFIG.disabled.set(false).save();
        VoicechatClient.CLIENT_CONFIG.onboardingFinished.set(true).save();
        ClientManager.getPlayerStateManager().onFinishOnboarding();
        MC.setScreen(null);
    }

    public static void onConnecting() {
        if (!OnboardingManager.isOnboarding()) {
            return;
        }
        ChatUtils.sendModMessage((Component)Component.translatable((String)"message.voicechat.set_up", (Object[])new Object[]{KeyEvents.KEY_VOICE_CHAT.getTranslatedKeyMessage().copy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE})}));
    }
}

