/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.client;

import com.illusivesoulworks.bedspreads.BedspreadsCommonMod;
import com.illusivesoulworks.bedspreads.common.DecoratedBedBlockEntity;
import com.illusivesoulworks.bedspreads.common.integration.glowingbanners.GlowingBannersIntegration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DecoratedBedBlockEntityRenderer
implements BlockEntityRenderer<DecoratedBedBlockEntity> {
    private final ModelPart headPiece;
    private final ModelPart footPiece;

    public DecoratedBedBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.headPiece = ctx.bakeLayer(ModelLayers.BED_HEAD);
        this.footPiece = ctx.bakeLayer(ModelLayers.BED_FOOT);
    }

    public void render(@Nonnull DecoratedBedBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        BannerPatternLayers list = blockEntity.getPatternList();
        Level world = blockEntity.getLevel();
        if (world != null) {
            BlockState blockstate = blockEntity.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)BlockEntityType.BED, BedBlock::getBlockType, BedBlock::getConnectedDirection, (DirectionProperty)ChestBlock.FACING, (BlockState)blockstate, (LevelAccessor)world, (BlockPos)blockEntity.getBlockPos(), (levelAccessor, blockPos) -> false);
            int i = ((Int2IntFunction)icallbackwrapper.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(light);
            this.renderPiece(poseStack, buffer, blockstate.getValue((Property)BedBlock.PART) == BedPart.HEAD ? this.headPiece : this.footPiece, (Direction)blockstate.getValue((Property)BedBlock.FACING), i, overlay, false, list, blockEntity);
        } else {
            this.renderPiece(poseStack, buffer, this.headPiece, Direction.SOUTH, light, overlay, false, list, blockEntity);
            this.renderPiece(poseStack, buffer, this.footPiece, Direction.SOUTH, light, overlay, true, list, blockEntity);
        }
    }

    private static int getLight(int light, int layer, DecoratedBedBlockEntity bedBlockEntity) {
        if (BedspreadsCommonMod.isGlowingBannersLoaded && GlowingBannersIntegration.isGlowing(bedBlockEntity, layer)) {
            return 0xF000F0;
        }
        return light;
    }

    private void renderPiece(PoseStack poseStack, MultiBufferSource buffer, ModelPart modelPart, Direction direction, int light, int overlay, boolean isHead, BannerPatternLayers patterns, DecoratedBedBlockEntity blockEntity) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5625, isHead ? -1.0 : 0.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f + direction.toYRot()));
        poseStack.translate(-0.5, -0.5, -0.5);
        Material material = new Material(Sheets.BANNER_SHEET, ResourceLocation.fromNamespaceAndPath((String)"bedspreads", (String)"entity/bed_base"));
        if (patterns != null) {
            DecoratedBedBlockEntityRenderer.renderPatterns(poseStack, buffer, light, overlay, modelPart, patterns, blockEntity);
        }
        VertexConsumer ivertexbuilder = material.buffer(buffer, RenderType::entityTranslucent);
        modelPart.render(poseStack, ivertexbuilder, light, overlay);
        poseStack.popPose();
    }

    public static void renderPatterns(PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, ModelPart modelRenderer, BannerPatternLayers patterns, DecoratedBedBlockEntity blockEntity) {
        Material baseMaterial = new Material(Sheets.BANNER_SHEET, ResourceLocation.fromNamespaceAndPath((String)"bedspreads", (String)"entity/banner/minecraft/base"));
        int newLight = DecoratedBedBlockEntityRenderer.getLight(light, -1, blockEntity);
        modelRenderer.render(poseStack, baseMaterial.buffer(buffer, RenderType::entityTranslucent), newLight, overlay, blockEntity.getBannerColor().getTextureDiffuseColor());
        List layers = patterns.layers();
        for (int i = 0; i < 16 && i < layers.size(); ++i) {
            BannerPatternLayers.Layer layer = (BannerPatternLayers.Layer)layers.get(i);
            Holder pattern = layer.pattern();
            int color = layer.color().getTextureDiffuseColor();
            String path = "entity/" + pattern.unwrapKey().map(key -> {
                ResourceLocation loc = key.location();
                return loc.getNamespace() + "/" + loc.getPath();
            }).orElse("minecraft/base");
            Material patternMaterial = new Material(Sheets.BANNER_SHEET, ResourceLocation.fromNamespaceAndPath((String)"bedspreads", (String)path));
            TextureAtlasSprite sprite = patternMaterial.sprite();
            ResourceLocation resourceLocation = sprite.contents().name();
            if (resourceLocation == MissingTextureAtlasSprite.getLocation()) continue;
            newLight = DecoratedBedBlockEntityRenderer.getLight(light, i, blockEntity);
            modelRenderer.render(poseStack, patternMaterial.buffer(buffer, RenderType::entityTranslucent), newLight, overlay, color);
        }
    }
}

