/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.common;

import com.illusivesoulworks.bedspreads.common.DecoratedBedBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class DecoratedBedBlock
extends BedBlock {
    public DecoratedBedBlock() {
        super(DyeColor.WHITE, BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).ignitedByLava().sound(SoundType.WOOD).strength(0.2f));
    }

    private static Direction getDirectionToOther(BedPart part, Direction facing) {
        return part == BedPart.FOOT ? facing : facing.getOpposite();
    }

    @Nonnull
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new DecoratedBedBlockEntity(pos, state);
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockEntity be = level.getBlockEntity(pos);
        return be instanceof DecoratedBedBlockEntity ? ((DecoratedBedBlockEntity)be).getItem() : super.getCloneItemStack(level, pos, state);
    }

    @Nonnull
    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, @Nonnull Player player) {
        BedPart bedpart = (BedPart)state.getValue((Property)PART);
        boolean flag = bedpart == BedPart.HEAD;
        BlockPos blockpos = pos.relative(DecoratedBedBlock.getDirectionToOther(bedpart, (Direction)state.getValue((Property)FACING)));
        BlockState iblockstate = worldIn.getBlockState(blockpos);
        BlockEntity blockentity = worldIn.getBlockEntity(pos);
        BlockEntity blockentityother = worldIn.getBlockEntity(blockpos);
        if (iblockstate.getBlock() == this && iblockstate.getValue((Property)PART) != bedpart) {
            worldIn.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            worldIn.levelEvent(player, 2001, blockpos, Block.getId((BlockState)iblockstate));
            if (!worldIn.isClientSide && !player.isCreative()) {
                if (flag) {
                    if (blockentity instanceof DecoratedBedBlockEntity) {
                        DecoratedBedBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)((DecoratedBedBlockEntity)blockentity).getItem());
                    }
                } else if (blockentityother instanceof DecoratedBedBlockEntity) {
                    DecoratedBedBlock.popResource((Level)worldIn, (BlockPos)blockpos, (ItemStack)((DecoratedBedBlockEntity)blockentityother).getItem());
                }
            }
            player.awardStat(Stats.BLOCK_MINED.get((Object)this));
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void setPlacedBy(Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        BlockPos blockpos = pos.relative((Direction)state.getValue((Property)FACING));
        worldIn.setBlock(blockpos, (BlockState)state.setValue((Property)PART, (Comparable)BedPart.HEAD), 3);
        worldIn.blockUpdated(pos, Blocks.AIR);
        state.updateNeighbourShapes((LevelAccessor)worldIn, pos, 3);
        BlockEntity blockentity = worldIn.getBlockEntity(pos);
        if (blockentity instanceof DecoratedBedBlockEntity) {
            ((DecoratedBedBlockEntity)blockentity).loadFromItemStack(stack);
        }
        if ((blockentity = worldIn.getBlockEntity(blockpos)) instanceof DecoratedBedBlockEntity) {
            ((DecoratedBedBlockEntity)blockentity).loadFromItemStack(stack);
        }
    }
}

