/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.common;

import com.illusivesoulworks.bedspreads.common.BedspreadsData;
import com.illusivesoulworks.bedspreads.common.BedspreadsRegistry;
import com.illusivesoulworks.bedspreads.common.DecoratedBedItem;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DecoratedBedBlockEntity
extends BlockEntity {
    private ItemStack bed = ItemStack.EMPTY;
    private ItemStack banner = ItemStack.EMPTY;
    private DyeColor bannerColor = DyeColor.WHITE;
    private BannerPatternLayers patterns;

    public DecoratedBedBlockEntity(BlockPos pos, BlockState state) {
        super(BedspreadsRegistry.DECORATED_BED_BLOCK_ENTITY.get(), pos, state);
    }

    public void loadFromItemStack(ItemStack stack) {
        this.patterns = null;
        BedspreadsData data = (BedspreadsData)stack.get(BedspreadsRegistry.BEDSPREADS_DATA.get());
        if (data != null) {
            this.bed = data.bed().copy();
            this.banner = data.banner().copy();
            if (!this.banner.isEmpty()) {
                this.bannerColor = DecoratedBedItem.getBannerColor(this.banner);
            }
        }
        this.patterns = (BannerPatternLayers)this.banner.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        if (!this.bed.isEmpty()) {
            tag.put("BedStack", this.bed.save(provider, (Tag)new CompoundTag()));
        }
        if (!this.banner.isEmpty()) {
            tag.put("BannerStack", this.banner.save(provider, (Tag)new CompoundTag()));
        }
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        this.bed = compound.contains("BedStack") ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("BedStack")) : ItemStack.EMPTY;
        ItemStack itemStack = this.banner = compound.contains("BannerStack") ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("BannerStack")) : ItemStack.EMPTY;
        if (!this.banner.isEmpty()) {
            this.bannerColor = DecoratedBedItem.getBannerColor(this.banner);
        }
        this.patterns = (BannerPatternLayers)this.banner.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public BannerPatternLayers getPatternList() {
        return this.patterns;
    }

    public ItemStack getItem() {
        ItemStack itemstack = new ItemStack((ItemLike)BedspreadsRegistry.DECORATED_BED_ITEM.get());
        itemstack.set(BedspreadsRegistry.BEDSPREADS_DATA.get(), (Object)new BedspreadsData(this.bed.copy(), this.banner.copy()));
        return itemstack;
    }

    public ItemStack getBanner() {
        return this.banner;
    }

    public DyeColor getBannerColor() {
        return this.bannerColor;
    }
}

