/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.common;

import com.illusivesoulworks.bedspreads.common.BedspreadsData;
import com.illusivesoulworks.bedspreads.common.BedspreadsRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.AbstractBannerBlock;

public class DecoratedBedItem
extends BedItem {
    public DecoratedBedItem() {
        super(BedspreadsRegistry.DECORATED_BED_BLOCK.get(), new Item.Properties().stacksTo(1));
    }

    public static ItemStack getBedStack(ItemStack stack) {
        BedspreadsData data;
        if (stack.getItem() instanceof DecoratedBedItem && (data = (BedspreadsData)stack.get(BedspreadsRegistry.BEDSPREADS_DATA.get())) != null) {
            return data.bed().copy();
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getBannerStack(ItemStack stack) {
        BedspreadsData data;
        if (stack.getItem() instanceof DecoratedBedItem && (data = (BedspreadsData)stack.get(BedspreadsRegistry.BEDSPREADS_DATA.get())) != null) {
            return data.banner().copy();
        }
        return ItemStack.EMPTY;
    }

    public static DyeColor getBannerColor(ItemStack stack) {
        if (!stack.isEmpty() && stack.getItem() instanceof BannerItem) {
            return ((AbstractBannerBlock)((BannerItem)stack.getItem()).getBlock()).getColor();
        }
        return DyeColor.WHITE;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        ItemStack bed = DecoratedBedItem.getBedStack(stack);
        ItemStack banner = DecoratedBedItem.getBannerStack(stack);
        if (!bed.isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)bed.getDescriptionId()).withStyle(ChatFormatting.GRAY));
        }
        if (!banner.isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)banner.getDescriptionId()).withStyle(ChatFormatting.GRAY));
            BannerItem.appendHoverTextFromBannerBlockEntityTag((ItemStack)banner, tooltipComponents);
        }
    }
}

