/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.common.recipe;

import com.illusivesoulworks.bedspreads.common.BedspreadsData;
import com.illusivesoulworks.bedspreads.common.BedspreadsRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AddPatternRecipe
extends CustomRecipe {
    public static final RecipeSerializer<AddPatternRecipe> CRAFTING_ADD_PATTERN = new SimpleCraftingRecipeSerializer(AddPatternRecipe::new);

    public AddPatternRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@Nonnull CraftingInput inv, @Nonnull Level level) {
        ItemStack itemstack = ItemStack.EMPTY;
        ItemStack itemstack1 = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BannerItem) {
                if (!itemstack.isEmpty()) {
                    return false;
                }
                itemstack = stack;
                continue;
            }
            if (stack.getItem() instanceof BedItem) {
                if (!itemstack1.isEmpty()) {
                    return false;
                }
                itemstack1 = stack;
                continue;
            }
            return false;
        }
        return !itemstack.isEmpty() && !itemstack1.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput inv, @Nonnull HolderLookup.Provider provider) {
        ItemStack itemstack = ItemStack.EMPTY;
        ItemStack itemstack1 = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BannerItem) {
                itemstack = stack.copy();
                continue;
            }
            if (!(stack.getItem() instanceof BedItem)) continue;
            itemstack1 = stack.copy();
        }
        if (itemstack1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)BedspreadsRegistry.DECORATED_BED_ITEM.get());
        stack.set(BedspreadsRegistry.BEDSPREADS_DATA.get(), (Object)new BedspreadsData(itemstack1.copy(), itemstack.copy()));
        return stack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return CRAFTING_ADD_PATTERN;
    }
}

