/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.common.recipe;

import com.illusivesoulworks.bedspreads.common.DecoratedBedItem;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class RemovePatternRecipe
extends CustomRecipe {
    public static final RecipeSerializer<RemovePatternRecipe> CRAFTING_REMOVE_PATTERN = new SimpleCraftingRecipeSerializer(RemovePatternRecipe::new);

    public RemovePatternRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@Nonnull CraftingInput inv, @Nonnull Level level) {
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (!itemstack.isEmpty() || !(stack.getItem() instanceof DecoratedBedItem)) {
                return false;
            }
            itemstack = stack.copy();
        }
        return !itemstack.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput inv, @Nonnull HolderLookup.Provider provider) {
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof DecoratedBedItem)) continue;
            itemstack = stack.copy();
            break;
        }
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return DecoratedBedItem.getBannerStack(itemstack);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item.isEmpty() || !(item.getItem() instanceof DecoratedBedItem)) continue;
            nonnulllist.set(i, (Object)DecoratedBedItem.getBedStack(item));
        }
        return nonnulllist;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return CRAFTING_REMOVE_PATTERN;
    }
}

