/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.mixin;

import com.illusivesoulworks.bedspreads.common.BedspreadsRegistry;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class MixinHooks {
    private static final Set<BlockState> DECORATED_BED_STATES = new HashSet<BlockState>();

    private static void initBlockStates() {
        if (DECORATED_BED_STATES.isEmpty()) {
            DECORATED_BED_STATES.addAll(BedspreadsRegistry.DECORATED_BED_BLOCK.get().getStateDefinition().getPossibleStates().stream().filter(state -> state.getValue((Property)BedBlock.PART) == BedPart.HEAD).collect(Collectors.toSet()));
        }
    }

    public static boolean containsDecoratedBed(PoiType poiType, BlockState state) {
        MixinHooks.initBlockStates();
        Holder poiTypeHolder = BuiltInRegistries.POINT_OF_INTEREST_TYPE.getHolder(PoiTypes.HOME).orElse(null);
        if (poiTypeHolder != null && poiType == poiTypeHolder.value()) {
            return DECORATED_BED_STATES.contains(state);
        }
        return false;
    }

    public static Optional<Holder<PoiType>> containsDecoratedBed(BlockState state) {
        MixinHooks.initBlockStates();
        Holder poiTypeHolder = BuiltInRegistries.POINT_OF_INTEREST_TYPE.getHolder(PoiTypes.HOME).orElse(null);
        if (poiTypeHolder != null && DECORATED_BED_STATES.contains(state)) {
            return Optional.of(poiTypeHolder);
        }
        return Optional.empty();
    }
}

