/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.bedspreads.platform;

import com.illusivesoulworks.bedspreads.common.DecoratedBedItem;
import com.illusivesoulworks.bedspreads.common.item.DecoratedBedNeoForgeItem;
import com.illusivesoulworks.bedspreads.platform.services.IPlatformRegistry;
import com.illusivesoulworks.bedspreads.registry.RegistryObject;
import com.illusivesoulworks.bedspreads.registry.RegistryProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgePlatformRegistry
implements IPlatformRegistry {
    @Override
    public <T> RegistryProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        Optional containerOpt = ModList.get().getModContainerById(modId);
        if (containerOpt.isEmpty()) {
            throw new NullPointerException("Cannot find mod container for id " + modId);
        }
        ModContainer cont = (ModContainer)containerOpt.get();
        if (cont instanceof FMLModContainer) {
            FMLModContainer fmlModContainer = (FMLModContainer)cont;
            DeferredRegister register = DeferredRegister.create(resourceKey, (String)modId);
            register.register(fmlModContainer.getEventBus());
            return new Provider(modId, register);
        }
        throw new ClassCastException("The container of the mod " + modId + " is not a FML one!");
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> builder, Block ... blocks) {
        return BlockEntityType.Builder.of(builder::apply, (Block[])blocks).build(null);
    }

    @Override
    public DecoratedBedItem getItem() {
        return new DecoratedBedNeoForgeItem();
    }

    @Override
    public Holder<PoiType> getPoiType(ResourceKey<PoiType> key) {
        return BuiltInRegistries.POINT_OF_INTEREST_TYPE.getHolder(key).orElse(null);
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    private static class Provider<T>
    implements RegistryProvider<T> {
        private final String modId;
        private final DeferredRegister<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, DeferredRegister<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final DeferredHolder obj = this.registry.register(name, supplier);
            RegistryObject ro = new RegistryObject<I>(this){

                @Override
                public ResourceKey<I> getResourceKey() {
                    return obj.getKey();
                }

                @Override
                public ResourceLocation getId() {
                    return obj.getId();
                }

                @Override
                public I get() {
                    return obj.get();
                }

                @Override
                public Holder<I> asHolder() {
                    return obj.getDelegate();
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Set<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }
    }
}

