/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model.kinetic;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartialModelState {
    private final Map<Property<?>, Object> backingMap = new HashMap();

    public int size() {
        return this.backingMap.size();
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public boolean containsKey(Property<?> key) {
        return this.backingMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    public <T extends Comparable<T>> T get(Property<T> key) {
        return (T)((Comparable)this.backingMap.get(key));
    }

    @Nullable
    public <T extends Comparable<T>> T put(Property<T> key, T value) {
        return (T)((Comparable)this.backingMap.put(key, value));
    }

    public <T extends Comparable<T>> T putState(Property<T> key, BlockState value) {
        return (T)((Comparable)this.backingMap.put(key, value.getValue(key)));
    }

    public <T extends Comparable<T>> T remove(Property<T> key) {
        return (T)((Comparable)this.backingMap.remove(key));
    }

    public void putAll(@NotNull Map<? extends Property<?>, ?> m) {
        this.backingMap.putAll(m);
    }

    public void clear() {
        this.backingMap.clear();
    }

    @NotNull
    public Set<Property<?>> keySet() {
        return this.backingMap.keySet();
    }

    @NotNull
    public Collection<Object> values() {
        return this.backingMap.values();
    }

    @NotNull
    public Set<Map.Entry<Property<?>, Object>> entrySet() {
        return this.backingMap.entrySet();
    }

    public static PartialModelState fromBlockState(BlockState state, Property<?> ... properties) {
        PartialModelState modelState = new PartialModelState();
        for (Property<?> property : properties) {
            modelState.putState(property, state);
        }
        return modelState;
    }

    public boolean equalsState(BlockState state) {
        for (Map.Entry<Property<?>, Object> entry : this.backingMap.entrySet()) {
            if (Objects.equals(state.getValue(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartialModelState)) {
            return false;
        }
        PartialModelState that = (PartialModelState)o;
        return Objects.equals(this.backingMap, that.backingMap);
    }

    public int hashCode() {
        return Objects.hashCode(this.backingMap);
    }

    public String toString() {
        return "[" + this.backingMap.entrySet().stream().map(entry -> ((Property)entry.getKey()).getName() + "=" + entry.getValue().toString()).collect(Collectors.joining(",")) + "]";
    }
}

