/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power;

import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellPowerTags;
import net.spell_power.api.SpellResistance;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.config.AttributesConfig;
import net.spell_power.internals.AttributeUtil;
import net.tiny_config.ConfigManager;

public class SpellPowerMod {
    public static final String ID = "spell_power";
    public static final ConfigManager<AttributesConfig> attributesConfig = new ConfigManager("attributes", (Object)AttributesConfig.defaults()).builder().setDirectory("spell_power").sanitize(true).validate(AttributesConfig::isValid).build();
    private static boolean potionsRegistered = false;
    @Deprecated(forRemoval=true)
    public static AttributesConfig.AttributeScope attributeScopeOverride = null;

    public static void init() {
        AttributesConfig config = (AttributesConfig)attributesConfig.safeValue();
        if (config.migrate_attributes_base) {
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
                ServerPlayer player = handler.getPlayer();
                SpellPowerMod.migrateAttributes(player);
            });
        }
    }

    public static void registerAttributes() {
        for (Map.Entry<String, SpellPowerMechanics.Entry> entry : SpellPowerMechanics.all.entrySet()) {
            entry.getValue().registerAttribute();
        }
        for (SpellResistance.Attributes.Entry resistance : SpellResistance.Attributes.all) {
            resistance.registerAttribute();
        }
        for (SpellSchool school : SpellSchools.all()) {
            school.registerAttribute();
        }
        EnchantmentEvents.ALLOW_ENCHANTING.register((enchantment, target, enchantingContext) -> {
            List enchantmentAttributes;
            if (((AttributesConfig)SpellPowerMod.attributesConfig.value).enchantments_require_matching_attribute && enchantment.is(SpellPowerTags.Enchantments.REQUIRES_MATCHING_ATTRIBUTE) && (enchantmentAttributes = (List)((Enchantment)enchantment.value()).effects().get(EnchantmentEffectComponents.ATTRIBUTES)) != null && !enchantmentAttributes.isEmpty()) {
                boolean intersect;
                ItemAttributeModifiers itemAttributes = (ItemAttributeModifiers)target.getComponents().get(DataComponents.ATTRIBUTE_MODIFIERS);
                if (itemAttributes == null) {
                    return TriState.FALSE;
                }
                if (itemAttributes.modifiers().isEmpty()) {
                    itemAttributes = target.getItem().getDefaultAttributeModifiers();
                }
                if (!(intersect = AttributeUtil.attributesIntersect(enchantmentAttributes, itemAttributes))) {
                    return TriState.FALSE;
                }
            }
            return TriState.DEFAULT;
        });
    }

    public static void registerStatusEffects() {
        ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)ID, (String)"potion_effect");
        float bonus_per_stack = 0.1f;
        for (SpellSchool school : SpellSchools.all()) {
            ResourceLocation id = school.id;
            if (school.ownedBoostEffect == null || school.attributeEntry == null) continue;
            school.ownedBoostEffect.addAttributeModifier(school.attributeEntry, modifierId, (double)bonus_per_stack, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            Registry.register((Registry)BuiltInRegistries.MOB_EFFECT, (String)id.toString(), (Object)school.ownedBoostEffect);
        }
        AttributesConfig safeConfig = (AttributesConfig)attributesConfig.safeValue();
        for (Map.Entry<String, SpellPowerMechanics.Entry> entry : SpellPowerMechanics.all.entrySet()) {
            SpellPowerMechanics.Entry secondary = entry.getValue();
            ResourceLocation id = secondary.id;
            AttributesConfig.EffectConfig config = safeConfig.secondary_effects.get(secondary.name);
            if (config != null) {
                bonus_per_stack = config.bonus_per_stack;
            }
            secondary.boostEffect.addAttributeModifier(secondary.attributeEntry, modifierId, (double)bonus_per_stack, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            Registry.register((Registry)BuiltInRegistries.MOB_EFFECT, (String)id.toString(), (Object)secondary.boostEffect);
        }
    }

    public static void registerPotionsInternal() {
        if (((AttributesConfig)SpellPowerMod.attributesConfig.safeValue()).register_potions) {
            SpellPowerMod.registerPotions();
        }
    }

    public static void registerPotions() {
        if (potionsRegistered) {
            return;
        }
        potionsRegistered = true;
        for (SpellSchool spellSchool : SpellSchools.all()) {
            if (spellSchool.archetype != SpellSchool.Archetype.MAGIC || spellSchool.id.getPath().contains("generic")) continue;
            spellSchool.registerPotion();
        }
        for (Map.Entry entry : SpellPowerMechanics.all.entrySet()) {
            SpellPowerMechanics.Entry mechanic = (SpellPowerMechanics.Entry)entry.getValue();
            Holder entry2 = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)mechanic.boostEffect);
            if (entry2 == null) continue;
            Potion potion = new Potion(new MobEffectInstance[]{new MobEffectInstance(entry2, 3600)});
            Registry.register((Registry)BuiltInRegistries.POTION, (ResourceLocation)SpellPowerMod.potionIdFrom(mechanic.id), (Object)potion);
        }
    }

    public static ResourceLocation potionIdFrom(ResourceLocation id) {
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getNamespace() + "." + id.getPath()));
    }

    @Deprecated(forRemoval=true)
    public static AttributesConfig.AttributeScope attributeScope() {
        return attributeScopeOverride;
    }

    public static void migrateAttributes(ServerPlayer player) {
        List<Holder> attributes = SpellSchools.all().stream().filter(school -> school.isMagicArchetype() && school.ownsAttribute()).map(school -> school.attributeEntry).toList();
        for (Holder attribute : attributes) {
            AttributeInstance instance;
            if (attribute == null || (instance = player.getAttribute(attribute)) == null) continue;
            double defaultValue = ((Attribute)attribute.value()).getDefaultValue();
            if (instance.getBaseValue() == defaultValue) continue;
            instance.setBaseValue(defaultValue);
        }
    }
}

