/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.api.statuseffects.VulnerabilityEffect;

public class SpellPower {
    public static final ArrayList<Function<VulnerabilityQuery, List<Vulnerability>>> vulnerabilitySources = new ArrayList<Function>(Arrays.asList(query -> {
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        for (MobEffectInstance effect : query.entity.getActiveEffects()) {
            Object patt0$temp = effect.getEffect().value();
            if (!(patt0$temp instanceof VulnerabilityEffect)) continue;
            VulnerabilityEffect vulnerabilityEffect = (VulnerabilityEffect)patt0$temp;
            vulnerabilities.add(vulnerabilityEffect.getVulnerability(query.school, effect.getAmplifier()));
        }
        return vulnerabilities;
    }));

    public static Vulnerability getVulnerability(LivingEntity livingEntity, SpellSchool school) {
        VulnerabilityQuery query = new VulnerabilityQuery(livingEntity, school);
        ArrayList<Vulnerability> elements = new ArrayList<Vulnerability>();
        for (Function<VulnerabilityQuery, List<Vulnerability>> source : vulnerabilitySources) {
            elements.addAll((Collection<Vulnerability>)source.apply(query));
        }
        return Vulnerability.sum(elements);
    }

    public static Result getSpellPower(SpellSchool school, LivingEntity entity) {
        AttributeInstance instance;
        SpellSchool.QueryArgs args = new SpellSchool.QueryArgs(entity);
        double power = school.getValue(SpellSchool.Trait.POWER, args);
        if (school.archetype == SpellSchool.Archetype.MAGIC && (instance = entity.getAttributes().getInstance(school.attributeEntry)) != null) {
            double flatPower = SpellPower.getAttributeFlatValue(instance);
            double genericSpellPower = entity.getAttributeValue(SpellSchools.GENERIC.attributeEntry);
            double multiplier = genericSpellPower / (double)SpellSchools.GENERIC.attributeBaseValue();
            power += flatPower * (multiplier - 1.0);
        }
        return new Result(school, power, school.getValue(SpellSchool.Trait.CRIT_CHANCE, args), school.getValue(SpellSchool.Trait.CRIT_DAMAGE, args));
    }

    private static double getAttributeFlatValue(AttributeInstance instance) {
        double result = 0.0;
        for (AttributeModifier modifier : instance.getModifiers()) {
            if (modifier.operation() != AttributeModifier.Operation.ADD_VALUE) continue;
            result += modifier.amount();
        }
        return result;
    }

    public static float getHaste(LivingEntity entity, SpellSchool school) {
        SpellSchool.QueryArgs args = new SpellSchool.QueryArgs(entity);
        return (float)school.getValue(SpellSchool.Trait.HASTE, args);
    }

    public record VulnerabilityQuery(LivingEntity entity, SpellSchool school) {
    }

    public record Vulnerability(float powerBaseMultiplier, float criticalChanceBonus, float criticalDamageBonus) {
        public static final Vulnerability none = new Vulnerability(0.0f, 0.0f, 0.0f);

        public static Vulnerability sum(List<Vulnerability> elements) {
            Vulnerability value = none;
            for (Vulnerability element : elements) {
                value = new Vulnerability(value.powerBaseMultiplier + element.powerBaseMultiplier, value.criticalChanceBonus + element.criticalChanceBonus, value.criticalDamageBonus + element.criticalDamageBonus);
            }
            return value;
        }

        public Vulnerability multiply(float value) {
            return new Vulnerability(this.powerBaseMultiplier * value, this.criticalChanceBonus * value, this.criticalDamageBonus * value);
        }
    }

    public record Result(SpellSchool school, double baseValue, double criticalChance, double criticalDamage) {
        private static Random rng = new Random();

        public static Result empty(SpellSchool school) {
            return new Result(school, 0.0, 0.0, 0.0);
        }

        public Value random() {
            return this.value(CriticalStrikeMode.ALLOWED, Vulnerability.none);
        }

        public double randomValue() {
            return this.random().amount();
        }

        public Value random(Vulnerability vulnerability) {
            return this.value(CriticalStrikeMode.ALLOWED, vulnerability);
        }

        public double randomValue(Vulnerability vulnerability) {
            return this.random(vulnerability).amount();
        }

        public Value nonCritical() {
            return this.value(CriticalStrikeMode.DISABLED, Vulnerability.none);
        }

        public double nonCriticalValue() {
            return this.nonCritical().amount();
        }

        public Value forcedCritical() {
            return this.value(CriticalStrikeMode.FORCED, Vulnerability.none);
        }

        public double forcedCriticalValue() {
            return this.forcedCritical().amount();
        }

        private Value value(CriticalStrikeMode mode, Vulnerability vulnerability) {
            double value = this.baseValue * (double)(1.0f + vulnerability.powerBaseMultiplier);
            boolean isCritical = false;
            if (mode != CriticalStrikeMode.DISABLED) {
                boolean bl = isCritical = mode == CriticalStrikeMode.FORCED || (double)rng.nextFloat() < this.criticalChance + (double)vulnerability.criticalChanceBonus;
                if (isCritical) {
                    value *= this.criticalDamage + (double)vulnerability.criticalDamageBonus;
                }
            }
            return new Value(value, isCritical);
        }

        private static enum CriticalStrikeMode {
            DISABLED,
            ALLOWED,
            FORCED;

        }

        public record Value(double amount, boolean isCritical) {
        }
    }
}

