/*
 * Decompiled with CFR 0.152.
 */
package net.relics_rpgs.item;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.relics_rpgs.config.ItemConfig;
import net.relics_rpgs.item.Group;
import net.relics_rpgs.item.RelicFactory;
import net.relics_rpgs.spell.RelicSpells;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigUtil;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

public class RelicItems {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final String COMBAT_ROLL_MODID = "combat_roll";
    public static final String COMBAT_ROLL_COUNT = "combat_roll:count";
    public static final String CRITICAL_STRIKE_MODID = "critical_strike";
    public static final String CRITICAL_STRIKE_CHANCE = "critical_strike:chance";
    public static final String CRITICAL_STRIKE_DAMAGE = "critical_strike:damage";
    private static final float tier_0_multiplier = 0.05f;
    public static final Entry JEWEL_FIGURINE_RUBY = RelicItems.add(new Entry(1, "jewel_figurine_ruby", "Ruby Serpent Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry JEWEL_FIGURINE_TOPAZ = RelicItems.add(new Entry(1, "jewel_figurine_topaz", "Topaz Fox Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellSchools.ARCANE.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(SpellSchools.FIRE.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry JEWEL_FIGURINE_CITRINE = RelicItems.add(new Entry(1, "jewel_figurine_citrine", "Citrine Cat Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellSchools.HEALING.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(SpellSchools.LIGHTNING.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry JEWEL_FIGURINE_JADE = RelicItems.add(new Entry(1, "jewel_figurine_jade", "Jade Hawk Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry JEWEL_FIGURINE_SAPPHIRE = RelicItems.add(new Entry(1, "jewel_figurine_sapphire", "Sapphire Turtle Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(Attributes.MAX_HEALTH.getRegisteredName(), 2.0f, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry JEWEL_FIGURINE_TANZANITE = RelicItems.add(new Entry(1, "jewel_figurine_tanzanite", "Tanzanite Bat Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellSchools.FROST.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(SpellSchools.SOUL.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry LESSER_ROLL = RelicItems.add(new Entry(1, "lesser_roll", "Feather Talisman")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))).withConditionalAttributes("combat_roll", List.of(new AttributeModifier("combat_roll:count", 1.0f, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry LESSER_EVASION = RelicItems.add(new Entry(1, "lesser_evasion", "Lucky Coin")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellEngineAttributes.EVASION_CHANCE.id.toString(), 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry LESSER_MELEE_CRIT_CHANCE = RelicItems.add(new Entry(1, "lesser_melee_crit_chance", "Dice of Fate")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))).withConditionalAttributes("critical_strike", List.of(new AttributeModifier("critical_strike:chance", 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry LESSER_MELEE_CRIT_DAMAGE = RelicItems.add(new Entry(1, "lesser_melee_crit_damage", "Serrated Fang")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))).withConditionalAttributes("critical_strike", List.of(new AttributeModifier("critical_strike:damage", 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry LESSER_USE_DAMAGE = RelicItems.add(new Entry(1, "lesser_use_damage", "Meteorite Whetstone")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_use_damage.id()));
    public static final Entry LESSER_USE_DEX = RelicItems.add(new Entry(1, "lesser_use_dex", "Medal of Valor")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_use_dex.id()));
    public static final Entry LESSER_USE_RANGED = RelicItems.add(new Entry(1, "lesser_use_ranged", "Eagle Eye")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_use_ranged.id()));
    public static final Entry LESSER_USE_HEALTH = RelicItems.add(new Entry(1, "lesser_use_health", "Everflowing Vial")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_use_health.id()));
    public static final Entry LESSER_USE_SPELL_POWER = RelicItems.add(new Entry(1, "lesser_use_spell_power", "Silver Crescent")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_use_spell_power.id()));
    public static final Entry LESSER_USE_SPELL_HASTE = RelicItems.add(new Entry(1, "lesser_use_spell_haste", "Sorcerer\u2019s Chronograph")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_use_spell_haste.id()));
    public static final Entry LESSER_PROC_SPELL_CRIT = RelicItems.add(new Entry(1, "lesser_proc_spell_crit", "Scarab of Infinite Mysteries")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_proc_spell_crit.id()));
    public static final Entry LESSER_PROC_CRIT_DAMAGE = RelicItems.add(new Entry(1, "lesser_proc_crit_damage", "Splintered Focus Crystal")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_proc_crit_damage.id()));
    public static final Entry LESSER_PROC_ARCANE_FIRE = RelicItems.add(new Entry(1, "lesser_proc_arcane_fire", "Spellfire Stone")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_proc_arcane_fire.id()));
    public static final Entry LESSER_PROC_FROST_HEALING = RelicItems.add(new Entry(1, "lesser_proc_frost_healing", "Frozen Lotus")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.lesser_proc_frost_healing.id()));
    public static final Entry MEDIUM_PROC_ATTACK_DAMAGE = RelicItems.add(new Entry(2, "medium_proc_attack_damage", "Badge of Tenacity")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_proc_attack_damage.id()));
    public static final Entry MEDIUM_PROC_ATTACK_SPEED = RelicItems.add(new Entry(2, "medium_proc_attack_speed", "Dragon Skull Trophy")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_proc_attack_speed.id()));
    public static final Entry MEDIUM_PROC_RANGED_DAMAGE = RelicItems.add(new Entry(2, "medium_proc_ranged_damage", "Golden Bowstring")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_proc_ranged_damage.id()));
    public static final Entry MEDIUM_PROC_DEFENSE = RelicItems.add(new Entry(2, "medium_proc_defense", "Titanium Nautilus Shell")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_proc_defense.id()));
    public static final Entry MEDIUM_PROC_EVASION = RelicItems.add(new Entry(2, "medium_proc_evasion", "Monkey Talisman")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_proc_evasion.id()));
    public static final Entry MEDIUM_PROC_SPELL_POWER = RelicItems.add(new Entry(2, "medium_proc_spell_power", "Crystal Skull")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_proc_spell_power.id()));
    public static final Entry MEDIUM_PROC_SPELL_HASTE = RelicItems.add(new Entry(2, "medium_proc_spell_haste", "Hourglass of the Unraveller")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_proc_spell_haste.id()));
    public static final Entry MEDIUM_USE_ARCANE_POWER = RelicItems.add(new Entry(2, "medium_proc_arcane_power", "Arcane Orb")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_use_arcane_power.id()));
    public static final Entry MEDIUM_USE_FIRE_POWER = RelicItems.add(new Entry(2, "medium_proc_fire_power", "Fire Orb")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_use_fire_power.id()));
    public static final Entry MEDIUM_USE_FROST_POWER = RelicItems.add(new Entry(2, "medium_proc_frost_power", "Frost Orb")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_use_frost_power.id()));
    public static final Entry MEDIUM_USE_HEALING_POWER = RelicItems.add(new Entry(2, "medium_proc_healing_power", "Holy Orb")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.medium_use_healing_power.id()));
    public static final Entry GREATER_PERK_ROLL_DAMAGE = RelicItems.add(new Entry(3, "greater_perk_roll_damage", "Thunderbird Feather")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_perk_roll_damage.id()));
    public static final Entry GREATER_HEALING_TAKEN = RelicItems.add(new Entry(3, "greater_healing_taken", "Ankh")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellEngineAttributes.HEALING_TAKEN.id.toString(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry GREATER_PERK_MELEE_STUN = RelicItems.add(new Entry(3, "greater_perk_melee_stun", "Blackjack")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_perk_melee_stun.id()));
    public static final Entry GREATER_PERK_RANGED_LEVITATE = RelicItems.add(new Entry(3, "greater_perk_ranged_levitate", "Updraft Arrow")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_perk_ranged_levitate.id()));
    public static final Entry GREATER_PERK_SPELL_STUN = RelicItems.add(new Entry(3, "greater_perk_spell_stun", "Malevolent Gaze")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_perk_spell_stun.id()));
    public static final Entry GREATER_PERK_DEFENSE_BLOCK = RelicItems.add(new Entry(3, "greater_perk_defense_block", "Sacred Wardstone")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_perk_defense_block.id()));
    public static final Entry GREATER_PERK_EVASION_ATTACK = RelicItems.add(new Entry(3, "greater_perk_evasion_attack", "Captain's Hook")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_perk_evasion_attack.id()));
    public static final Entry GREATER_PERK_SHIELD_RESET = RelicItems.add(new Entry(3, "greater_perk_shield_reset", "Etienne's Enigma")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_perk_shield_reset.id()));
    public static final Entry GREATER_PERK_HEAL_CLEANSE = RelicItems.add(new Entry(3, "greater_perk_heal_cleanse", "Holy Water")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_perk_heal_cleanse.id()));
    public static final Entry GREATER_PROC_PHYSICAL_TRANCE = RelicItems.add(new Entry(3, "greater_proc_physical_trance", "Sharpened Dragon Scale")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_proc_physical_trance.id())).lootTheme("dragon");
    public static final Entry GREATER_PROC_SPELL_TRANCE = RelicItems.add(new Entry(3, "greater_proc_spell_trance", "Twisted Dragon Scale")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_proc_spell_trance.id())).lootTheme("dragon");
    public static final Entry GREATER_PERK_HEAL_DANGER = RelicItems.add(new Entry(3, "greater_perk_heal_danger", "Verdant Dragon Scale")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_perk_heal_danger.id())).lootTheme("dragon");
    public static final Entry GREATER_PROC_DEFENSE_DANGER = RelicItems.add(new Entry(3, "greater_proc_defense_danger", "Petrified Dragon Scale")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.greater_proc_defense_danger.id())).lootTheme("dragon");
    public static final Entry SUPERIOR_USE_AREA_ATTACK_DAMAGE = RelicItems.add(new Entry(4, "superior_use_area_attack_damage", "Horn of the White City")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.superior_use_area_attack_damage.id()));
    public static final Entry SUPERIOR_USE_AREA_DEFENSE_HEALTH = RelicItems.add(new Entry(4, "superior_use_area_defense_health", "Heart of the Beast")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.superior_use_area_defense_health.id()));
    public static final Entry SUPERIOR_USE_ZONE_SPELL_POWER = RelicItems.add(new Entry(4, "superior_use_zone_spell_power", "Black Orb")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.superior_use_zone_spell_power.id()));
    public static final Entry SUPERIOR_USE_ZONE_HEALING_TAKEN = RelicItems.add(new Entry(4, "superior_use_zone_healing_taken", "Glimmering Crystal Sliver")).spell(SpellContainerHelper.createForRelic((ResourceLocation)RelicSpells.superior_use_zone_healing_taken.id()));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register(Map<String, ItemConfig.Entry> config) {
        for (Entry entry : entries) {
            String key = entry.id().toString();
            ItemConfig.Entry configEntry = config.get(key);
            if (configEntry != null) {
                entry.config(configEntry);
                continue;
            }
            config.put(key, entry.config());
        }
        for (Entry entry : entries) {
            if (!entry.isEnabled()) continue;
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)entry.item().get());
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Entry entry : entries) {
                if (!entry.isEnabled()) continue;
                content.accept((ItemLike)entry.item().get());
            }
        });
    }

    public static final class Entry {
        private final int tier;
        public String lootTheme;
        private final String name;
        private final String translatedName;
        private ItemConfig.Entry config;
        public ItemConfig.Entry defaults;
        private final Supplier<Item> item;
        private SpellContainer spellContainer;

        public Entry(int tier, String name, String translatedName) {
            this(tier, name, translatedName, ItemConfig.Entry.EMPTY);
        }

        public Entry(int tier, String name, String translatedName, ItemConfig.Entry config) {
            this.tier = tier;
            this.name = name;
            this.translatedName = translatedName;
            this.config = config;
            this.defaults = config;
            this.item = Suppliers.memoize(() -> {
                Rarity rarity;
                Item.Properties settings = new Item.Properties().stacksTo(1);
                List<AttributeModifier> selectedAttributes = this.config().selectedAttributes();
                ItemAttributeModifiers attributes = selectedAttributes != null && !selectedAttributes.isEmpty() ? ConfigUtil.attributesComponent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)name), selectedAttributes).build() : null;
                SpellContainer spellContainer = this.spellContainer();
                if (spellContainer != null) {
                    settings = settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)spellContainer);
                }
                if (this.config().durability > 0) {
                    settings = settings.durability(this.config().durability);
                }
                if ((rarity = Entry.rarityFrom(tier)) != Rarity.COMMON) {
                    settings = settings.rarity(rarity);
                }
                return RelicFactory.getFactory().apply(new RelicFactory.ItemArgs(settings, attributes));
            });
        }

        private static Rarity rarityFrom(int tier) {
            return switch (tier) {
                case 0, 1 -> Rarity.COMMON;
                case 2 -> Rarity.UNCOMMON;
                case 3 -> Rarity.RARE;
                default -> Rarity.EPIC;
            };
        }

        public int tier() {
            return this.tier;
        }

        public ResourceLocation id() {
            return ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)this.name);
        }

        public String name() {
            return this.name;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public ItemConfig.Entry config() {
            return this.config;
        }

        public Supplier<Item> item() {
            return this.item;
        }

        @Nullable
        public SpellContainer spellContainer() {
            return this.spellContainer;
        }

        public Entry config(ItemConfig.Entry config) {
            this.config = config;
            return this;
        }

        public Entry spell(SpellContainer spellContainer) {
            this.spellContainer = spellContainer;
            return this;
        }

        public Entry lootTheme(String lootTheme) {
            this.lootTheme = lootTheme;
            return this;
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

