/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import net.fabric_extras.ranged_weapon.api.CustomBow;
import net.fabric_extras.ranged_weapon.api.CustomCrossbow;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class RangedWeaponEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        for (CustomBow bow : CustomBow.instances) {
            this.registerAnvilRecipe(registry, (Item)bow);
        }
        for (CustomCrossbow crossbow : CustomCrossbow.instances) {
            this.registerAnvilRecipe(registry, (Item)crossbow);
        }
    }

    private void registerAnvilRecipe(EmiRegistry registry, Item item) {
        Ingredient repairIngredient;
        if (item instanceof CustomBow) {
            CustomBow bow = (CustomBow)item;
            repairIngredient = bow.getRepairIngredientSupplier().get();
        } else if (item instanceof CustomCrossbow) {
            CustomCrossbow crossbow = (CustomCrossbow)item;
            repairIngredient = crossbow.getRepairIngredientSupplier().get();
        } else {
            return;
        }
        Holder.Reference itemEntry = item.builtInRegistryHolder();
        if (itemEntry == null || itemEntry.unwrapKey().isEmpty()) {
            return;
        }
        ResourceLocation itemId = ((ResourceKey)itemEntry.unwrapKey().get()).location();
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("anvil_repair_rwa/" + itemId.getPath()));
        EmiStack input = EmiStack.of((ItemLike)item);
        EmiIngredient repairMaterial = EmiIngredient.of((Ingredient)repairIngredient);
        EmiAnvilRecipe recipe = new EmiAnvilRecipe(input, repairMaterial, id);
        registry.addRecipe((EmiRecipe)recipe);
    }
}

