/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin;

import java.util.Random;
import net.fabric_extras.ranged_weapon.internal.ArrowExtension;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={AbstractArrow.class})
public abstract class PersistentProjectileEntityMixin
implements ArrowExtension {
    private static final Random CRIT_RANDOM = new Random();
    @Shadow
    private double baseDamage;
    private boolean rwa_modified = false;

    @Shadow
    public abstract boolean isCritArrow();

    @ModifyVariable(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at=@At(value="STORE"), ordinal=0)
    private int modifyCritDamage(int value) {
        if (!this.isCritArrow()) {
            return value;
        }
        AbstractArrow projectile = (AbstractArrow)this;
        double velocity = projectile.getDeltaMovement().length();
        float critMultiplier = 1.0f + (0.1f + CRIT_RANDOM.nextFloat() * 0.5f);
        return (int)Math.round(Mth.clamp((double)(velocity * this.baseDamage * (double)critMultiplier), (double)0.0, (double)2.147483647E9));
    }

    @Override
    public void rwa_markModified(boolean modified) {
        this.rwa_modified = modified;
    }

    @Override
    public boolean rwa_isModified() {
        return this.rwa_modified;
    }
}

