/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.api;

import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import hunternif.mc.api.MarkerAPI;
import hunternif.mc.api.TileAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.api.impl.MarkerApiImpl;
import hunternif.mc.impl.atlas.api.impl.TileApiImpl;
import hunternif.mc.impl.atlas.item.AtlasItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AtlasAPI {
    private static final int VERSION = 5;
    private static final TileAPI tiles = new TileApiImpl();
    private static final MarkerAPI markers = new MarkerApiImpl();

    public static int getVersion() {
        return 5;
    }

    public static Item getAtlasItem() {
        return (Item)RegistryHelper.items().get(VersionHelper.toLoc((String)"antiqueatlas:antique_atlas"));
    }

    public static TileAPI getTileAPI() {
        return tiles;
    }

    public static MarkerAPI getMarkerAPI() {
        return markers;
    }

    public static List<Integer> getPlayerAtlases(Player player) {
        if (!AntiqueAtlas.CONFIG.itemNeeded) {
            return Collections.singletonList(player.getUUID().hashCode());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty() || !(stack.getItem() instanceof AtlasItem)) continue;
            list.add(AtlasItem.getAtlasID(stack));
        }
        for (ItemStack stack : player.getInventory().offhand) {
            if (stack.isEmpty() || !(stack.getItem() instanceof AtlasItem)) continue;
            list.add(AtlasItem.getAtlasID(stack));
        }
        return list;
    }
}

