/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas;

import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.resource.ReloadListener;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.client.TextureConfig;
import hunternif.mc.impl.atlas.client.TextureSetConfig;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileTextureConfig;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.marker.MarkerTextureConfig;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;

public class ClientProxy
implements PreparableReloadListener,
ReloadListener {
    public void initClient(ReloadListeners reloadListener) {
        TextureConfig textureConfig = new TextureConfig(Textures.TILE_TEXTURES_MAP);
        reloadListener.listenTo((ReloadListener)textureConfig);
        TextureSetMap textureSetMap = TextureSetMap.instance();
        TextureSetConfig textureSetConfig = new TextureSetConfig(textureSetMap);
        reloadListener.listenTo((ReloadListener)textureSetConfig);
        TileTextureMap tileTextureMap = TileTextureMap.instance();
        TileTextureConfig tileTextureConfig = new TileTextureConfig(tileTextureMap, textureSetMap);
        reloadListener.listenTo((ReloadListener)tileTextureConfig);
        reloadListener.listenTo((ReloadListener)this);
        MarkerTextureConfig markerTextureConfig = new MarkerTextureConfig();
        reloadListener.listenTo((ReloadListener)markerTextureConfig);
        for (MarkerType type : MarkerType.REGISTRY) {
            type.initMips();
        }
    }

    public static void assignCustomBiomeTextures(ClientLevel world) {
        for (Map.Entry entry : world.registryAccess().registryOrThrow(Registries.BIOME).entrySet()) {
            ResourceLocation id = world.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)entry.getValue()));
            if (TileTextureMap.instance().isRegistered(id)) continue;
            TileTextureMap.instance().autoRegister(id, (ResourceKey<Biome>)((ResourceKey)entry.getKey()));
        }
    }

    public String getName() {
        return AntiqueAtlas.id("proxy").toString();
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier synchronizer, ResourceManager manager, ProfilerFiller prepareProfiler, ProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)synchronizer).wait(arg_0))).thenCompose(t -> CompletableFuture.runAsync(() -> {
            for (MarkerType type : MarkerType.REGISTRY) {
                type.initMips();
            }
        }, applyExecutor));
    }

    public ResourceLocation id() {
        return AntiqueAtlas.id("proxy");
    }
}

