/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.api.impl;

import hunternif.mc.api.TileAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileDataStorage;
import hunternif.mc.impl.atlas.network.packet.c2s.play.PutTileC2SPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.DeleteGlobalTileS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.PutGlobalTileS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.PutTileS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TileApiImpl
implements TileAPI {
    @Override
    public void putTile(Level world, int atlasID, ResourceLocation tile, int chunkX, int chunkZ) {
        if (tile == null) {
            Log.error("Attempted to put custom tile with null name", new Object[0]);
            return;
        }
        ResourceKey dimension = world.dimension();
        if (world.isClientSide) {
            new PutTileC2SPacket(atlasID, chunkX, chunkZ, tile).send();
        } else {
            AtlasData data = AntiqueAtlas.tileData.getData(atlasID, world);
            data.setTile((ResourceKey<Level>)dimension, chunkX, chunkZ, tile);
            for (Player syncedPlayer : data.getSyncedPlayers()) {
                new PutTileS2CPacket(atlasID, (ResourceKey<Level>)dimension, chunkX, chunkZ, tile).send((ServerPlayer)syncedPlayer);
            }
        }
    }

    @Override
    public ResourceLocation getTile(Level world, int atlasID, int chunkX, int chunkZ) {
        AtlasData data = AntiqueAtlas.tileData.getData(atlasID, world);
        return data.getWorldData((ResourceKey<Level>)world.dimension()).getTile(chunkX, chunkZ);
    }

    @Override
    public void putGlobalTile(Level world, ResourceLocation tileId, int chunkX, int chunkZ) {
        if (tileId == null) {
            Log.error("Attempted to put global tile with null name", new Object[0]);
            return;
        }
        if (world.isClientSide) {
            Log.warn("Client attempted to put global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlas.globalTileData.getData(world);
        data.setTile(chunkX, chunkZ, tileId);
        new PutGlobalTileS2CPacket((ResourceKey<Level>)world.dimension(), chunkX, chunkZ, tileId).send((ServerLevel)world);
    }

    @Override
    public ResourceLocation getGlobalTile(Level world, int chunkX, int chunkZ) {
        TileDataStorage data = AntiqueAtlas.globalTileData.getData(world);
        return data.getTile(chunkX, chunkZ);
    }

    @Override
    public void deleteGlobalTile(Level world, int chunkX, int chunkZ) {
        if (world.isClientSide) {
            Log.warn("Client attempted to delete global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlas.globalTileData.getData(world);
        if (data.getTile(chunkX, chunkZ) != null) {
            data.removeTile(chunkX, chunkZ);
            new DeleteGlobalTileS2CPacket((ResourceKey<Level>)world.dimension(), chunkX, chunkZ).send((ServerLevel)world);
        }
    }
}

