/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import hunternif.mc.api.client.AtlasClientAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.client.SetTileRenderer;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.SubTileQuartet;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileRenderIterator;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.client.gui.GuiAtlas;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.item.AntiqueAtlasItems;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Rect;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class OverlayRenderer {
    private static final int CHUNK_SIZE = 16;
    private static final float INNER_ELEMENTS_SCALE_FACTOR = 1.9f;
    private Player player;
    private Level world;

    public void drawOverlay(PoseStack matrices, MultiBufferSource vertexConsumer, int light, ItemStack atlas) {
        if (Minecraft.getInstance().screen instanceof GuiAtlas) {
            return;
        }
        if (Minecraft.getInstance().level == null || Minecraft.getInstance().player == null) {
            return;
        }
        this.player = Minecraft.getInstance().player;
        this.world = Minecraft.getInstance().level;
        if (!atlas.isEmpty() && atlas.getItem() == AntiqueAtlasItems.Items.ATLAS) {
            int atlasID = AtlasItem.getAtlasID(atlas);
            this.drawMinimap(matrices, atlasID, vertexConsumer, light);
        }
    }

    private void drawMinimap(PoseStack matrices, int atlasID, MultiBufferSource buffer, int light) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrices.pushPose();
        matrices.translate(0.0, 0.0, 0.01);
        Textures.BOOK.drawWithLight(buffer, matrices, 0, 0, 465, 327, light);
        matrices.popPose();
        matrices.pushPose();
        matrices.scale(1.9f, 1.9f, 1.0f);
        this.drawTiles(buffer, matrices, atlasID, light);
        matrices.translate(0.0, 0.0, -0.01);
        if (AntiqueAtlas.CONFIG.markerSize > 0) {
            this.drawMarkers(buffer, matrices, atlasID, light);
        }
        matrices.popPose();
        matrices.translate(0.0, 0.0, -0.02);
        this.drawPlayer(buffer, matrices, light);
        matrices.translate(0.0, 0.0, -0.01);
        Textures.BOOK_FRAME.drawWithLight(buffer, matrices, 0, 0, 465, 327, light);
        RenderSystem.disableBlend();
    }

    private void drawTiles(MultiBufferSource buffer, PoseStack matrices, int atlasID, int light) {
        Rect iteratorScope = this.getChunkCoverage(this.player.position());
        TileRenderIterator iter = AtlasClientAPI.getTileAPI().getTiles(this.world, atlasID, iteratorScope, 1);
        Vec3 chunkPosition = this.player.position().multiply(0.0625, 0.0625, 0.0625);
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        SetTileRenderer renderer = new SetTileRenderer(buffer, matrices, AntiqueAtlas.CONFIG.tileSize / 2, light);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                float relativeChunkPositionX = (float)((double)subtile.x / 2.0 + (double)iteratorScope.minX - chunkPosition.x);
                float relativeChunkPositionY = (float)((double)subtile.y / 2.0 + (double)iteratorScope.minY - chunkPosition.z);
                renderer.addTileCorner(TileTextureMap.instance().getTexture(subtile).getTexture(), shapeMiddleX + (int)Math.floor(relativeChunkPositionX * (float)AntiqueAtlas.CONFIG.tileSize), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * (float)AntiqueAtlas.CONFIG.tileSize), subtile.getTextureU(), subtile.getTextureV());
            }
        }
        renderer.draw();
    }

    private void drawMarkers(MultiBufferSource buffer, PoseStack matrices, int atlasID, int light) {
        WorldData biomeData = AntiqueAtlas.tileData.getData(atlasID, this.world).getWorldData((ResourceKey<Level>)this.world.dimension());
        DimensionMarkersData globalMarkersData = AntiqueAtlas.globalMarkersData.getData().getMarkersDataInWorld((ResourceKey<Level>)this.world.dimension());
        this.drawMarkersData(buffer, matrices, globalMarkersData, biomeData, light);
        MarkersData markersData = AntiqueAtlas.markersData.getMarkersData(atlasID, (Level)Minecraft.getInstance().level);
        if (markersData != null) {
            DimensionMarkersData localMarkersData = markersData.getMarkersDataInWorld((ResourceKey<Level>)this.world.dimension());
            this.drawMarkersData(buffer, matrices, localMarkersData, biomeData, light);
        }
    }

    private void drawPlayer(MultiBufferSource buffer, PoseStack matrices, int light) {
        matrices.pushPose();
        matrices.translate(232.0f, 163.0f, 0.0f);
        matrices.mulPose(new Quaternionf().rotateZ((this.player.getYHeadRot() + 180.0f) * ((float)Math.PI / 180)));
        matrices.translate((double)(-AntiqueAtlas.CONFIG.playerIconWidth) / 2.0, (double)(-AntiqueAtlas.CONFIG.playerIconHeight) / 2.0, 0.0);
        Textures.PLAYER.drawWithLight(buffer, matrices, 0, 0, AntiqueAtlas.CONFIG.playerIconWidth, AntiqueAtlas.CONFIG.playerIconHeight, light);
        matrices.popPose();
    }

    private void drawMarkersData(MultiBufferSource buffer, PoseStack matrices, DimensionMarkersData markersData, WorldData biomeData, int light) {
        Rect mcchunks = this.getChunkCoverage(this.player.position());
        Rect chunks = new Rect(mcchunks.minX / 8, mcchunks.minY / 8, (int)Math.ceil((float)mcchunks.maxX / 8.0f), (int)Math.ceil((float)mcchunks.maxY / 8.0f));
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        Vec3 chunkPosition = this.player.position().multiply(0.0625, 0.0625, 0.0625);
        for (int x = chunks.minX; x <= chunks.maxX; ++x) {
            for (int z = chunks.minY; z <= chunks.maxY; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(x, z);
                if (markers == null) continue;
                for (Marker marker : markers) {
                    float relativeChunkPositionX = (float)((double)marker.getChunkX() - chunkPosition.x);
                    float relativeChunkPositionY = (float)((double)marker.getChunkZ() - chunkPosition.z);
                    this.renderMarker(buffer, matrices, marker, shapeMiddleX + (int)Math.floor(relativeChunkPositionX * 8.0f), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * 8.0f), biomeData, light);
                }
            }
        }
    }

    private void renderMarker(MultiBufferSource buffer, PoseStack matrices, Marker marker, int x, int y, WorldData biomeData, int light) {
        int tileHalfSize = 2;
        if (x + tileHalfSize > 240 || x - tileHalfSize < 3 || y + tileHalfSize >= 166 || y - tileHalfSize < 0) {
            return;
        }
        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        MarkerType type = (MarkerType)MarkerType.REGISTRY.get(marker.getType());
        MarkerRenderInfo info = type.getRenderInfo(1.0, AntiqueAtlas.CONFIG.tileSize, 1.0);
        info.tex.drawWithLight(buffer, matrices, x - 8 + 4, y - 8 + 4, 16, 16, light);
    }

    private Rect getChunkCoverage(Vec3 position) {
        int minChunkX = (int)Math.floor(position.x / 16.0 - (double)(310.0f / (4.0f * (float)AntiqueAtlas.CONFIG.tileSize)));
        int minChunkY = (int)Math.floor(position.z / 16.0 - (double)(218.0f / (4.0f * (float)AntiqueAtlas.CONFIG.tileSize)));
        int maxChunkX = (int)Math.ceil(position.x / 16.0 + (double)(310.0f / (4.0f * (float)AntiqueAtlas.CONFIG.tileSize)));
        int maxChunkY = (int)Math.ceil(position.z / 16.0 + (double)(218.0f / (4.0f * (float)AntiqueAtlas.CONFIG.tileSize)));
        return new Rect(minChunkX -= 4, minChunkY -= 3, maxChunkX += 4, maxChunkY += 2);
    }
}

