/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetConfig;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.core.scaning.TileHeightType;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class TileTextureConfig
implements ResourceReloadListener<Map<ResourceLocation, ResourceLocation>>,
ReloadListener {
    public static final ResourceLocation ID = AntiqueAtlas.id("tile_textures");
    private final TileTextureMap tileTextureMap;
    private final TextureSetMap textureSetMap;

    public TileTextureConfig(TileTextureMap biomeTextureMap, TextureSetMap textureSetMap) {
        this.tileTextureMap = biomeTextureMap;
        this.textureSetMap = textureSetMap;
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, ResourceLocation>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, ResourceLocation> map = new HashMap<ResourceLocation, ResourceLocation>();
            try {
                for (Map.Entry id : manager.listResources("atlas/tiles", s -> s.toString().endsWith(".json")).entrySet()) {
                    ResourceLocation tile_id = VersionHelper.toLoc((String)((ResourceLocation)id.getKey()).getNamespace(), (String)((ResourceLocation)id.getKey()).getPath().replace("atlas/tiles/", "").replace(".json", ""));
                    try {
                        Resource resource = (Resource)id.getValue();
                        InputStream stream = resource.open();
                        try (InputStreamReader reader = new InputStreamReader(stream);){
                            JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            int version = object.getAsJsonPrimitive("version").getAsInt();
                            if (version == 1) {
                                ResourceLocation texture_set = VersionHelper.toLoc((String)object.get("texture_set").getAsString());
                                map.put(tile_id, texture_set);
                                for (TileHeightType layer : TileHeightType.values()) {
                                    map.put(ResourceLocation.tryParse((String)(String.valueOf(tile_id) + "_" + layer.getName())), texture_set);
                                }
                                continue;
                            }
                            if (version == 2) {
                                ResourceLocation default_entry = TileTextureMap.DEFAULT_TEXTURE;
                                try {
                                    default_entry = VersionHelper.toLoc((String)object.getAsJsonObject("texture_sets").get("default").getAsString());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                map.put(tile_id, default_entry);
                                for (TileHeightType layer : TileHeightType.values()) {
                                    ResourceLocation texture_set = default_entry;
                                    try {
                                        texture_set = VersionHelper.toLoc((String)object.getAsJsonObject("texture_sets").get(layer.getName()).getAsString());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    map.put(ResourceLocation.tryParse((String)(String.valueOf(tile_id) + "_" + String.valueOf((Object)layer))), texture_set);
                                }
                                continue;
                            }
                            AntiqueAtlas.LOG.warn("The tile " + String.valueOf(tile_id) + " is in the wrong version! Skipping.");
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        AntiqueAtlas.LOG.warn("Error reading tile mapping " + String.valueOf(tile_id) + "!", (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read tile mappings!", new Object[0]);
            }
            return map;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, ResourceLocation> tileMap, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : tileMap.entrySet()) {
                ResourceLocation tile_id = (ResourceLocation)entry.getKey();
                ResourceLocation texture_set = (ResourceLocation)entry.getValue();
                TextureSet set = this.textureSetMap.getByName((ResourceLocation)entry.getValue());
                if (set == null) {
                    AntiqueAtlas.LOG.error("Missing texture set `{}` for tile `{}`. Using default.", (Object)texture_set, (Object)tile_id);
                    set = this.tileTextureMap.getDefaultTexture();
                }
                this.tileTextureMap.setTexture((ResourceLocation)entry.getKey(), set);
                if (!AntiqueAtlas.CONFIG.resourcePackLogging) continue;
                Log.info("Loaded tile %s with texture set %s", tile_id, set.name);
            }
        }, executor);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return Collections.singleton(TextureSetConfig.ID);
    }
}

