/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.core.scaning.TileHeightType;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.Tags;

public class TileTextureMap {
    private static final TileTextureMap INSTANCE = new TileTextureMap();
    public static final ResourceLocation DEFAULT_TEXTURE = AntiqueAtlas.id("test");
    private final Map<ResourceLocation, TextureSet> textureMap = new HashMap<ResourceLocation, TextureSet>();

    public static TileTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(ResourceLocation tileId, TextureSet textureSet) {
        if (tileId == null) {
            return;
        }
        if (textureSet == null) {
            if (this.textureMap.remove(tileId) != null) {
                Log.warn("Removing old texture for %d", tileId);
            }
            return;
        }
        this.textureMap.put(tileId, textureSet);
    }

    public void setAllTextures(ResourceLocation tileId, TextureSet textureSet) {
        this.setTexture(tileId, textureSet);
        for (TileHeightType layer : TileHeightType.values()) {
            this.setTexture(ResourceLocation.tryParse((String)(String.valueOf(tileId) + "_" + String.valueOf((Object)layer))), textureSet);
        }
    }

    public TextureSet getDefaultTexture() {
        return TextureSetMap.instance().getByName(DEFAULT_TEXTURE);
    }

    public void autoRegister(ResourceLocation id, ResourceKey<Biome> biome) {
        if (biome == null || id == null) {
            Log.error("Given biome is null. Cannot autodetect a suitable texture set for that.", new Object[0]);
            return;
        }
        Optional<ResourceLocation> texture_set = TileTextureMap.guessFittingTextureSet(biome);
        if (texture_set.isPresent()) {
            this.setAllTextures(id, TextureSetMap.instance().getByName(texture_set.get()));
            Log.info("Auto-registered standard texture set for biome %s: %s", id, texture_set.get());
        } else {
            Log.error("Failed to auto-register a standard texture set for the biome '%s'. This is most likely caused by errors in the TextureSet configurations, check your resource packs first before reporting it as an issue!", id.toString());
            this.setAllTextures(id, this.getDefaultTexture());
        }
    }

    public static Optional<ResourceLocation> guessFittingTextureSet(ResourceKey<Biome> biome) {
        if (Minecraft.getInstance().level == null) {
            return Optional.empty();
        }
        Holder.Reference biomeTag = Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(biome);
        if (biomeTag.is(Tags.Biomes.IS_SWAMP)) {
            if (biomeTag.is(BiomeTags.IS_HILL)) {
                return Optional.of(AntiqueAtlas.id("swamp_hills"));
            }
            return Optional.of(AntiqueAtlas.id("swamp"));
        }
        if (biomeTag.is(BiomeTags.IS_OCEAN) || biomeTag.is(BiomeTags.IS_DEEP_OCEAN) || biomeTag.is(BiomeTags.IS_RIVER) || biomeTag.is(Tags.Biomes.IS_AQUATIC)) {
            if (biomeTag.is(Tags.Biomes.IS_ICY)) {
                return Optional.of(AntiqueAtlas.id("ice"));
            }
            return Optional.of(AntiqueAtlas.id("water"));
        }
        if (biomeTag.is(BiomeTags.IS_BEACH) || biomeTag.is(Tags.Biomes.IS_BEACH)) {
            return Optional.of(AntiqueAtlas.id("shore"));
        }
        if (biomeTag.is(BiomeTags.IS_JUNGLE)) {
            if (biomeTag.is(BiomeTags.IS_HILL)) {
                return Optional.of(AntiqueAtlas.id("jungle_hills"));
            }
            return Optional.of(AntiqueAtlas.id("jungle"));
        }
        if (biomeTag.is(Tags.Biomes.IS_SAVANNA) || biomeTag.is(Tags.Biomes.IS_SAVANNA_TREE)) {
            return Optional.of(AntiqueAtlas.id("savana"));
        }
        if (biomeTag.is(Tags.Biomes.IS_BADLANDS)) {
            return Optional.of(AntiqueAtlas.id("plateau_mesa"));
        }
        if (biomeTag.is(BiomeTags.IS_FOREST) || biomeTag.is(Tags.Biomes.IS_DENSE_VEGETATION) || biomeTag.is(Tags.Biomes.IS_DECIDUOUS_TREE) || biomeTag.is(Tags.Biomes.IS_CONIFEROUS_TREE)) {
            if (biomeTag.is(Tags.Biomes.IS_ICY) || biomeTag.is(Tags.Biomes.IS_SNOWY)) {
                if (biomeTag.is(BiomeTags.IS_HILL)) {
                    return Optional.of(AntiqueAtlas.id("snow_pines_hills"));
                }
                return Optional.of(AntiqueAtlas.id("snow_pines"));
            }
            if (biomeTag.is(Tags.Biomes.IS_CONIFEROUS_TREE)) {
                if (biomeTag.is(BiomeTags.IS_HILL)) {
                    return Optional.of(AntiqueAtlas.id("pines_hills"));
                }
                return Optional.of(AntiqueAtlas.id("pines"));
            }
            if (biomeTag.is(BiomeTags.IS_HILL)) {
                return Optional.of(AntiqueAtlas.id("forest_hills"));
            }
            return Optional.of(AntiqueAtlas.id("forest"));
        }
        if (biomeTag.is(Tags.Biomes.IS_PLAINS) || biomeTag.is(Tags.Biomes.IS_SNOWY_PLAINS) || biomeTag.is(Tags.Biomes.IS_SPARSE_VEGETATION)) {
            if (biomeTag.is(Tags.Biomes.IS_ICY) || biomeTag.is(Tags.Biomes.IS_SNOWY)) {
                if (biomeTag.is(BiomeTags.IS_HILL)) {
                    return Optional.of(AntiqueAtlas.id("snow_hills"));
                }
                return Optional.of(AntiqueAtlas.id("snow"));
            }
            if (biomeTag.is(BiomeTags.IS_HILL)) {
                return Optional.of(AntiqueAtlas.id("hills"));
            }
            return Optional.of(AntiqueAtlas.id("plains"));
        }
        if (biomeTag.is(Tags.Biomes.IS_ICY)) {
            if (biomeTag.is(BiomeTags.IS_HILL)) {
                return Optional.of(AntiqueAtlas.id("mountains_snow_caps"));
            }
            return Optional.of(AntiqueAtlas.id("ice_spikes"));
        }
        if (biomeTag.is(Tags.Biomes.IS_DESERT)) {
            if (biomeTag.is(BiomeTags.IS_HILL)) {
                return Optional.of(AntiqueAtlas.id("desert_hills"));
            }
            return Optional.of(AntiqueAtlas.id("desert"));
        }
        if (biomeTag.is(Tags.Biomes.IS_TAIGA)) {
            return Optional.of(AntiqueAtlas.id("snow"));
        }
        if (biomeTag.is(Tags.Biomes.IS_MOUNTAIN) || biomeTag.is(Tags.Biomes.IS_MOUNTAIN_SLOPE)) {
            return Optional.of(AntiqueAtlas.id("mountains"));
        }
        if (biomeTag.is(Tags.Biomes.IS_MOUNTAIN_PEAK)) {
            return Optional.of(AntiqueAtlas.id("mountains_snow_caps"));
        }
        if (biomeTag.is(Tags.Biomes.IS_END) || biomeTag.is(Tags.Biomes.IS_OUTER_END_ISLAND)) {
            if (biomeTag.is(Tags.Biomes.IS_DENSE_VEGETATION) || biomeTag.is(Tags.Biomes.IS_SPARSE_VEGETATION)) {
                return Optional.of(AntiqueAtlas.id("end_island_plants"));
            }
            return Optional.of(AntiqueAtlas.id("end_island"));
        }
        if (biomeTag.is(Tags.Biomes.IS_MUSHROOM)) {
            return Optional.of(AntiqueAtlas.id("mushroom"));
        }
        if (biomeTag.is(Tags.Biomes.IS_NETHER) || biomeTag.is(BiomeTags.IS_NETHER)) {
            return Optional.of(AntiqueAtlas.id("soul_sand_valley"));
        }
        if (biomeTag.is(Tags.Biomes.IS_VOID)) {
            return Optional.of(AntiqueAtlas.id("end_void"));
        }
        if (biomeTag.is(Tags.Biomes.IS_UNDERGROUND)) {
            AntiqueAtlas.LOG.warn("Underground biomes aren't supported yet.");
        }
        if (biomeTag.is(BiomeTags.IS_BADLANDS)) {
            return Optional.of(AntiqueAtlas.id("mesa"));
        }
        return TileTextureMap.guessFittingTextureSetFallback((Biome)biomeTag.value());
    }

    public static Optional<ResourceLocation> guessFittingTextureSetFallback(Biome biome) {
        return Optional.ofNullable(null);
    }

    public boolean isRegistered(ResourceLocation id) {
        return this.textureMap.containsKey(id);
    }

    public TextureSet getTextureSet(ResourceLocation tile) {
        if (tile == null) {
            return this.getDefaultTexture();
        }
        return this.textureMap.getOrDefault(tile, this.getDefaultTexture());
    }

    public ITexture getTexture(SubTile subTile) {
        return this.getTextureSet(subTile.tile).getTexture(subTile.variationNumber);
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, TextureSet> entry : this.textureMap.entrySet()) {
            Arrays.stream(entry.getValue().textures).forEach(iTexture -> list.add(iTexture.getTexture()));
        }
        return list;
    }
}

