/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponentButton;
import net.minecraft.client.gui.GuiGraphics;

public class GuiArrowButton
extends GuiComponentButton {
    private static final int WIDTH = 12;
    private static final int HEIGHT = 12;
    private final ArrowDirection direction;

    private GuiArrowButton(ArrowDirection direction) {
        this.setSize(12, 12);
        this.direction = direction;
    }

    static GuiArrowButton up() {
        return new GuiArrowButton(ArrowDirection.UP);
    }

    static GuiArrowButton down() {
        return new GuiArrowButton(ArrowDirection.DOWN);
    }

    static GuiArrowButton left() {
        return new GuiArrowButton(ArrowDirection.LEFT);
    }

    static GuiArrowButton right() {
        return new GuiArrowButton(ArrowDirection.RIGHT);
    }

    @Override
    public void render(GuiGraphics matrices, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int x = this.getGuiX();
        int y = this.getGuiY();
        if (this.isMouseOver) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            int distanceSq = (mouseX - x - this.getWidth() / 2) * (mouseX - x - this.getWidth() / 2) + (mouseY - y - this.getHeight() / 2) * (mouseY - y - this.getHeight() / 2);
            double alpha = distanceSq < 400 ? 0.5 : Math.pow(distanceSq, -0.28);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha));
        }
        int u = 0;
        int v = 0;
        switch (this.direction.ordinal()) {
            case 2: {
                u = 0;
                v = 0;
                break;
            }
            case 3: {
                u = 0;
                v = 12;
                break;
            }
            case 0: {
                u = 12;
                v = 0;
                break;
            }
            case 1: {
                u = 12;
                v = 12;
            }
        }
        Textures.BTN_ARROWS.draw(matrices, x, y, u, v, 12, 12);
        RenderSystem.disableBlend();
    }

    public static enum ArrowDirection {
        UP("Up"),
        DOWN("Down"),
        LEFT("Left"),
        RIGHT("Right");

        public final String description;

        private ArrowDirection(String text) {
            this.description = text;
        }
    }
}

