/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import hunternif.mc.api.client.AtlasClientAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.SubTileQuartet;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileRenderIterator;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.client.gui.ExportUpdateListener;
import hunternif.mc.impl.atlas.client.gui.GuiArrowButton;
import hunternif.mc.impl.atlas.client.gui.GuiBlinkingMarker;
import hunternif.mc.impl.atlas.client.gui.GuiBookmarkButton;
import hunternif.mc.impl.atlas.client.gui.GuiMarkerBookmark;
import hunternif.mc.impl.atlas.client.gui.GuiMarkerFinalizer;
import hunternif.mc.impl.atlas.client.gui.GuiPositionButton;
import hunternif.mc.impl.atlas.client.gui.GuiScaleBar;
import hunternif.mc.impl.atlas.client.gui.ProgressBarOverlay;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponent;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponentButton;
import hunternif.mc.impl.atlas.client.gui.core.GuiCursor;
import hunternif.mc.impl.atlas.client.gui.core.GuiScrollingContainer;
import hunternif.mc.impl.atlas.client.gui.core.GuiStates;
import hunternif.mc.impl.atlas.client.gui.core.IButtonListener;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.client.texture.TileTexture;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.packet.c2s.play.PutBrowsingPositionC2SPacket;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.ExportImageUtil;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.MathUtil;
import hunternif.mc.impl.atlas.util.Rect;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class GuiAtlas
extends GuiComponent {
    public static final int WIDTH = 310;
    public static final int HEIGHT = 218;
    private static final int MAP_BORDER_WIDTH = 17;
    private static final int MAP_BORDER_HEIGHT = 11;
    private static final int MAP_WIDTH = 276;
    private static final int MAP_HEIGHT = 194;
    private static final float PLAYER_ROTATION_STEPS = 16.0f;
    private static final int PLAYER_ICON_WIDTH = 7;
    private static final int PLAYER_ICON_HEIGHT = 8;
    public static final int MARKER_SIZE = 32;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final double MIN_SCALE_THRESHOLD = 0.5;
    private final long[] renderTimes = new long[30];
    private int renderTimesIndex = 0;
    private final GuiStates state = new GuiStates();
    private final GuiStates.IState NORMAL = new GuiStates.SimpleState();
    private final GuiStates.IState HIDING_MARKERS = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle((Component)Component.translatable((String)"gui.antiqueatlas.showMarkers"));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_SHOW_MARKERS);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle((Component)Component.translatable((String)"gui.antiqueatlas.hideMarkers"));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_HIDE_MARKERS);
        }
    };
    private final GuiStates.IState PLACING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnMarker.setSelected(false);
        }
    };
    private final GuiStates.IState DELETING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.addChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.removeChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(false);
        }
    };
    private final GuiCursor eraser = new GuiCursor();
    private final GuiStates.IState EXPORTING_IMAGE = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnExportPng.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnExportPng.setSelected(false);
        }
    };
    private final GuiArrowButton btnUp;
    private final GuiArrowButton btnDown;
    private final GuiArrowButton btnLeft;
    private final GuiArrowButton btnRight;
    private final GuiBookmarkButton btnExportPng;
    private final GuiBookmarkButton btnMarker;
    private final GuiBookmarkButton btnDelMarker;
    private final GuiBookmarkButton btnShowMarkers;
    private final GuiPositionButton btnPosition;
    private static final int BUTTON_PAUSE = 8;
    private static final int navigateStep = 24;
    private GuiComponentButton selectedButton = null;
    private long timeButtonPressed = 0L;
    private boolean isDragging = false;
    private int mapOffsetX;
    private int mapOffsetY;
    private float mapOffsetDeltaX;
    private float mapOffsetDeltaY;
    private Integer targetOffsetX;
    private Integer targetOffsetY;
    private boolean followPlayer;
    private final GuiScaleBar scaleBar = new GuiScaleBar();
    private final GuiScrollingContainer markers = new GuiScrollingContainer();
    private double mapScale;
    private int tileHalfSize;
    private int tile2ChunkScale;
    private DimensionMarkersData localMarkersData;
    private DimensionMarkersData globalMarkersData;
    private Marker hoveredMarker;
    private final GuiMarkerFinalizer markerFinalizer = new GuiMarkerFinalizer();
    private final GuiBlinkingMarker blinkingIcon = new GuiBlinkingMarker();
    private Player player;
    private ItemStack stack;
    private WorldData biomeData;
    private double screenScale;
    private final ProgressBarOverlay progressBar = new ProgressBarOverlay(100, 2);
    private long lastUpdateMillis = System.currentTimeMillis();
    private int scaleAlpha = 255;
    private int scaleClipIndex = 0;
    private final int zoomLevelOne = 8;
    private int zoomLevel = 8;
    private final String[] zoomNames = new String[]{"256", "128", "64", "32", "16", "8", "4", "2", "1", "1/2", "1/4", "1/8", "1/16", "1/32", "1/64", "1/128", "1/256"};
    private Thread exportThread;

    public GuiAtlas() {
        this.setSize(310, 218);
        this.setMapScale(0.5);
        this.followPlayer = true;
        this.setInterceptKeyboard(true);
        this.btnUp = GuiArrowButton.up();
        this.addChild(this.btnUp).offsetGuiCoords(148, 10);
        this.btnDown = GuiArrowButton.down();
        this.addChild(this.btnDown).offsetGuiCoords(148, 194);
        this.btnLeft = GuiArrowButton.left();
        this.addChild(this.btnLeft).offsetGuiCoords(15, 100);
        this.btnRight = GuiArrowButton.right();
        this.addChild(this.btnRight).offsetGuiCoords(283, 100);
        this.btnPosition = new GuiPositionButton();
        this.btnPosition.setEnabled(!this.followPlayer);
        this.addChild(this.btnPosition).offsetGuiCoords(283, 194);
        IButtonListener<GuiComponentButton> positionListener = button -> {
            this.selectedButton = button;
            if (((Object)((Object)button)).equals((Object)this.btnPosition)) {
                this.followPlayer = true;
                this.targetOffsetX = null;
                this.targetOffsetY = null;
                this.btnPosition.setEnabled(false);
            } else {
                this.navigateByButton(this.selectedButton);
                this.timeButtonPressed = this.player.getCommandSenderWorld().getGameTime();
            }
        };
        this.btnUp.addListener(positionListener);
        this.btnDown.addListener(positionListener);
        this.btnLeft.addListener(positionListener);
        this.btnRight.addListener(positionListener);
        this.btnPosition.addListener(positionListener);
        this.btnExportPng = new GuiBookmarkButton(this, 1, Textures.ICON_EXPORT, (Component)Component.translatable((String)"gui.antiqueatlas.exportImage")){

            @Override
            public boolean isEnabled() {
                return !ExportImageUtil.isExporting;
            }
        };
        this.addChild(this.btnExportPng).offsetGuiCoords(300, 75);
        this.btnExportPng.addListener(button -> {
            if (this.stack != null || !AntiqueAtlas.CONFIG.itemNeeded) {
                this.exportThread = new Thread(() -> this.exportImage(this.getAtlasID()), "Atlas file export thread");
                this.exportThread.start();
            }
        });
        this.btnMarker = new GuiBookmarkButton(0, Textures.ICON_ADD_MARKER, (Component)Component.translatable((String)"gui.antiqueatlas.addMarker"));
        this.addChild(this.btnMarker).offsetGuiCoords(300, 14);
        this.btnMarker.addListener(button -> {
            if (this.state.is(this.PLACING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !AntiqueAtlas.CONFIG.itemNeeded) {
                this.selectedButton = button;
                this.state.switchTo(this.PLACING_MARKER);
                if (GuiAtlas.hasShiftDown()) {
                    this.markerFinalizer.setMarkerData(this.player.getCommandSenderWorld(), this.getAtlasID(), this.player.getBlockX(), this.player.getBlockZ());
                    this.addChild(this.markerFinalizer);
                    this.blinkingIcon.setTexture(this.markerFinalizer.selectedType.getTexture(), 32, 32);
                    this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords(this.worldXToScreenX((int)this.player.getX()) - this.getGuiX() - 16, this.worldZToScreenY((int)this.player.getZ()) - this.getGuiY() - 16);
                    this.setInterceptKeyboard(true);
                    KeyMapping.releaseAll();
                    this.selectedButton = null;
                    this.state.switchTo(this.NORMAL);
                }
            }
        });
        this.btnDelMarker = new GuiBookmarkButton(2, Textures.ICON_DELETE_MARKER, (Component)Component.translatable((String)"gui.antiqueatlas.delMarker"));
        this.addChild(this.btnDelMarker).offsetGuiCoords(300, 33);
        this.btnDelMarker.addListener(button -> {
            if (this.state.is(this.DELETING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !AntiqueAtlas.CONFIG.itemNeeded) {
                this.selectedButton = button;
                this.state.switchTo(this.DELETING_MARKER);
            }
        });
        this.btnShowMarkers = new GuiBookmarkButton(3, Textures.ICON_HIDE_MARKERS, (Component)Component.translatable((String)"gui.antiqueatlas.hideMarkers"));
        this.addChild(this.btnShowMarkers).offsetGuiCoords(300, 52);
        this.btnShowMarkers.addListener(button -> {
            this.selectedButton = null;
            if (this.state.is(this.HIDING_MARKERS)) {
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !AntiqueAtlas.CONFIG.itemNeeded) {
                this.selectedButton = null;
                this.state.switchTo(this.HIDING_MARKERS);
            }
        });
        this.addChild(this.scaleBar).offsetGuiCoords(20, 198);
        this.scaleBar.setMapScale(1.0);
        this.addChild(this.markers).setRelativeCoords(-10, 14);
        this.markers.setViewportSize(21, 180);
        this.markers.setWheelScrollsVertically();
        this.markerFinalizer.addMarkerListener(this.blinkingIcon);
        this.eraser.setTexture(Textures.ERASER, 12, 14, 2, 11);
        this.state.switchTo(this.NORMAL);
    }

    public GuiAtlas prepareToOpen(ItemStack stack) {
        this.stack = stack;
        return this.prepareToOpen();
    }

    public void openMarkerFinalizer(Component name) {
        this.markerFinalizer.setMarkerData(this.player.getCommandSenderWorld(), this.getAtlasID(), (int)this.player.getX(), (int)this.player.getZ());
        this.addChild(this.markerFinalizer);
        if (name != null) {
            this.markerFinalizer.setMarkerName(name);
        }
        this.blinkingIcon.setTexture(this.markerFinalizer.selectedType.getTexture(), 32, 32);
        this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords(this.worldXToScreenX((int)this.player.getX()) - this.getGuiX() - 16, this.worldZToScreenY((int)this.player.getZ()) - this.getGuiY() - 16);
        this.setInterceptKeyboard(true);
        KeyMapping.releaseAll();
        this.selectedButton = null;
        this.state.switchTo(this.NORMAL);
    }

    public GuiAtlas prepareToOpen() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        this.player = Minecraft.getInstance().player;
        this.updateAtlasData();
        if (!this.followPlayer && AntiqueAtlas.CONFIG.doSaveBrowsingPos) {
            this.loadSavedBrowsingPosition();
        }
        return this;
    }

    public void loadSavedBrowsingPosition() {
        this.setMapScale(this.biomeData.getBrowsingZoom());
        this.mapOffsetX = this.biomeData.getBrowsingX();
        this.mapOffsetY = this.biomeData.getBrowsingY();
        this.isDragging = false;
    }

    @Override
    public void init() {
        super.init();
        if (this.state.is(this.EXPORTING_IMAGE)) {
            this.state.switchTo(this.NORMAL);
        }
        this.screenScale = Minecraft.getInstance().getWindow().getGuiScale();
        this.setCentered();
        this.updateBookmarkerList();
    }

    public void updateBookmarkerList() {
        this.markers.removeAllContent();
        this.markers.scrollTo(0, 0);
        if (this.localMarkersData == null) {
            return;
        }
        int contentY = 0;
        for (Marker marker : this.localMarkersData.getAllMarkers()) {
            if (!marker.isVisibleAhead() || marker.isGlobal()) continue;
            GuiMarkerBookmark bookmark = new GuiMarkerBookmark(marker);
            bookmark.addListener(button -> {
                if (this.state.is(this.NORMAL)) {
                    this.setTargetPosition(marker.getX(), marker.getZ());
                    this.followPlayer = false;
                    this.btnPosition.setEnabled(true);
                } else if (this.state.is(this.DELETING_MARKER)) {
                    AtlasClientAPI.getMarkerAPI().deleteMarker(this.player.getCommandSenderWorld(), this.getAtlasID(), marker.getId());
                    this.player.getCommandSenderWorld().playSound(this.player, this.player.blockPosition(), SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundSource.AMBIENT, 1.0f, 0.5f);
                    this.state.switchTo(this.NORMAL);
                }
            });
            this.markers.addContent(bookmark).setRelativeY(contentY);
            contentY += 20;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseState) {
        boolean isMouseOverMap;
        boolean result = super.mouseClicked(mouseX, mouseY, mouseState);
        if (this.state.is(this.EXPORTING_IMAGE)) {
            return result;
        }
        if (result) {
            return true;
        }
        if (mouseState == 1 && this.state.is(this.NORMAL)) {
            this.onClose();
            return true;
        }
        int mapX = (this.width - 276) / 2;
        int mapY = (this.height - 194) / 2;
        boolean bl = isMouseOverMap = mouseX >= (double)mapX && mouseX <= (double)(mapX + 276) && mouseY >= (double)mapY && mouseY <= (double)(mapY + 194);
        if (!this.state.is(this.NORMAL) && !this.state.is(this.HIDING_MARKERS)) {
            int atlasID = this.getAtlasID();
            if (this.state.is(this.PLACING_MARKER) && isMouseOverMap && mouseState == 0) {
                this.markerFinalizer.setMarkerData(this.player.getCommandSenderWorld(), atlasID, this.screenXToWorldX((int)mouseX), this.screenYToWorldZ((int)mouseY));
                this.addChild(this.markerFinalizer);
                this.blinkingIcon.setTexture(this.markerFinalizer.selectedType.getTexture(), 32, 32);
                this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords((int)mouseX - this.getGuiX() - 16, (int)mouseY - this.getGuiY() - 16);
                this.setInterceptKeyboard(true);
                KeyMapping.releaseAll();
                this.state.switchTo(this.NORMAL);
                return true;
            }
            if (this.state.is(this.DELETING_MARKER) && this.hoveredMarker != null && !this.hoveredMarker.isGlobal() && isMouseOverMap && mouseState == 0) {
                AtlasClientAPI.getMarkerAPI().deleteMarker(this.player.getCommandSenderWorld(), atlasID, this.hoveredMarker.getId());
                this.hoveredMarker = null;
                this.player.getCommandSenderWorld().playSound(this.player, this.player.blockPosition(), SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundSource.AMBIENT, 1.0f, 0.5f);
            }
            this.state.switchTo(this.NORMAL);
        } else if (isMouseOverMap && this.selectedButton == null && this.hoveredMarker == null) {
            this.isDragging = true;
            return true;
        }
        return false;
    }

    private void exportImage(int atlasID) {
        boolean showMarkers = !this.state.is(this.HIDING_MARKERS);
        this.state.switchTo(this.EXPORTING_IMAGE);
        ExportImageUtil.isExporting = true;
        File screenshot_folder = new File(Minecraft.getInstance().gameDirectory, "screenshots");
        if (!screenshot_folder.isDirectory()) {
            screenshot_folder.mkdir();
        }
        String outputname = "atlas-" + DATE_FORMAT.format(new Date());
        File file = new File(screenshot_folder, outputname + ".png");
        int i = 1;
        while (file.exists()) {
            file = new File(screenshot_folder, outputname + "_" + i + ".png");
            ++i;
        }
        try {
            Log.info("Exporting image from Atlas #%d to file %s", atlasID, file.getAbsolutePath());
            ExportImageUtil.exportPngImage(this.biomeData, this.globalMarkersData, this.localMarkersData, file, showMarkers);
            Log.info("Finished exporting image", new Object[0]);
        }
        catch (OutOfMemoryError e) {
            Log.warn(e, "Image is too large, trying to export in strips", new Object[0]);
            try {
                ExportImageUtil.exportPngImageTooLarge(this.biomeData, this.globalMarkersData, this.localMarkersData, file, showMarkers);
            }
            catch (OutOfMemoryError e2) {
                int minX = (this.biomeData.getScope().minX - 1) * 16;
                int minY = (this.biomeData.getScope().minY - 1) * 16;
                int outWidth = (this.biomeData.getScope().maxX + 2) * 16 - minX;
                int outHeight = (this.biomeData.getScope().maxY + 2) * 16 - minY;
                Log.error(e2, "Image is STILL too large, how massive is this map?! Answer: (%dx%d)", outWidth, outHeight);
                ExportUpdateListener.INSTANCE.setStatusString(I18n.get((String)"gui.antiqueatlas.export.tooLarge", (Object[])new Object[0]), new Object[0]);
                ExportImageUtil.isExporting = false;
                return;
            }
        }
        ExportImageUtil.isExporting = false;
        this.state.switchTo(showMarkers ? this.NORMAL : this.HIDING_MARKERS);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.navigateMap(0, 24);
        } else if (keyCode == 264) {
            this.navigateMap(0, -24);
        } else if (keyCode == 263) {
            this.navigateMap(24, 0);
        } else if (keyCode == 262) {
            this.navigateMap(-24, 0);
        } else if (keyCode == 61 || keyCode == 334) {
            this.setMapScale(this.mapScale * 2.0);
        } else if (keyCode == 45 || keyCode == 333) {
            this.setMapScale(this.mapScale / 2.0);
        } else if (keyCode == 256) {
            this.onClose();
        } else {
            KeyMapping[] hotbarKeys;
            for (KeyMapping bind : hotbarKeys = Minecraft.getInstance().options.keyHotbarSlots) {
                if (!bind.matches(keyCode, scanCode) || this.markerFinalizer.getParent() != null) continue;
                this.onClose();
                return false;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return true;
    }

    @Override
    public boolean mouseScrolled(double mx, double my, double wheelMove, double scrollY) {
        double origWheelMove = wheelMove;
        boolean handled = super.mouseScrolled(mx, my, origWheelMove, scrollY);
        if (!handled && wheelMove != 0.0) {
            double d = wheelMove = wheelMove > 0.0 ? 1.0 : -1.0;
            if (AntiqueAtlas.CONFIG.doReverseWheelZoom) {
                wheelMove *= -1.0;
            }
            double mouseOffsetX = (double)Minecraft.getInstance().getWindow().getWidth() / this.screenScale / 2.0 - this.getMouseX();
            double mouseOffsetY = (double)Minecraft.getInstance().getWindow().getHeight() / this.screenScale / 2.0 - this.getMouseY();
            double newScale = this.mapScale * Math.pow(2.0, wheelMove);
            double addOffsetX = 0.0;
            double addOffsetY = 0.0;
            if (Math.abs(mouseOffsetX) < 138.0 && Math.abs(mouseOffsetY) < 97.0) {
                addOffsetX = mouseOffsetX * wheelMove;
                addOffsetY = mouseOffsetY * wheelMove;
                if (wheelMove > 0.0) {
                    addOffsetX *= this.mapScale / newScale;
                    addOffsetY *= this.mapScale / newScale;
                }
            }
            this.setMapScale(newScale, (int)addOffsetX, (int)addOffsetY);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
            return true;
        }
        return handled;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseState) {
        boolean result = false;
        if (mouseState != -1) {
            result = this.selectedButton != null || this.isDragging;
            this.selectedButton = null;
            this.isDragging = false;
            this.mapOffsetDeltaX = 0.0f;
            this.mapOffsetDeltaY = 0.0f;
        }
        return super.mouseReleased(mouseX, mouseY, mouseState) || result;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int lastMouseButton, double deltaX, double deltaY) {
        boolean result = false;
        if (this.isDragging) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
            this.mapOffsetDeltaX = (float)((double)this.mapOffsetDeltaX + deltaX);
            this.mapOffsetDeltaY = (float)((double)this.mapOffsetDeltaY + deltaY);
            int offsetX = (int)((double)Math.signum(this.mapOffsetDeltaX) * Math.floor(Math.abs(this.mapOffsetDeltaX)));
            int offsetY = (int)((double)Math.signum(this.mapOffsetDeltaY) * Math.floor(Math.abs(this.mapOffsetDeltaY)));
            if (Math.abs(this.mapOffsetDeltaX) >= 1.0f) {
                this.mapOffsetDeltaX -= (float)offsetX;
                this.mapOffsetX += offsetX;
            }
            if (Math.abs(this.mapOffsetDeltaY) >= 1.0f) {
                this.mapOffsetDeltaY -= (float)offsetY;
                this.mapOffsetY += offsetY;
            }
            result = true;
        }
        return super.mouseDragged(mouseX, mouseY, lastMouseButton, deltaX, deltaY) || result;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.player == null) {
            return;
        }
        if (this.followPlayer) {
            this.setMapPosition(this.player.getBlockX(), this.player.getBlockZ());
        }
        if (this.player.getCommandSenderWorld().getGameTime() > this.timeButtonPressed + 8L) {
            this.navigateByButton(this.selectedButton);
        }
        if (this.targetOffsetX != null) {
            if (Math.abs(this.getTargetPositionX() - this.mapOffsetX) > 24) {
                this.navigateMap(this.getTargetPositionX() > this.mapOffsetX ? 24 : -24, 0);
            } else {
                this.mapOffsetX = this.getTargetPositionX();
                this.targetOffsetX = null;
            }
        }
        if (this.targetOffsetY != null) {
            if (Math.abs(this.getTargetPositionY() - this.mapOffsetY) > 24) {
                this.navigateMap(0, this.getTargetPositionY() > this.mapOffsetY ? 24 : -24);
            } else {
                this.mapOffsetY = this.getTargetPositionY();
                this.targetOffsetY = null;
            }
        }
        this.updateAtlasData();
    }

    private void updateAtlasData() {
        int atlasID = this.getAtlasID();
        this.biomeData = AntiqueAtlas.tileData.getData(atlasID, this.player.getCommandSenderWorld()).getWorldData((ResourceKey<Level>)this.player.getCommandSenderWorld().dimension());
        this.globalMarkersData = AntiqueAtlas.globalMarkersData.getData().getMarkersDataInWorld((ResourceKey<Level>)this.player.getCommandSenderWorld().dimension());
        MarkersData markersData = AntiqueAtlas.markersData.getMarkersData(atlasID, this.player.getCommandSenderWorld());
        this.localMarkersData = markersData != null ? markersData.getMarkersDataInWorld((ResourceKey<Level>)this.player.getCommandSenderWorld().dimension()) : null;
    }

    private void navigateByButton(GuiComponentButton btn) {
        if (btn == null) {
            return;
        }
        if (((Object)((Object)btn)).equals((Object)this.btnUp)) {
            this.navigateMap(0, 24);
        } else if (((Object)((Object)btn)).equals((Object)this.btnDown)) {
            this.navigateMap(0, -24);
        } else if (((Object)((Object)btn)).equals((Object)this.btnLeft)) {
            this.navigateMap(24, 0);
        } else if (((Object)((Object)btn)).equals((Object)this.btnRight)) {
            this.navigateMap(-24, 0);
        }
    }

    private void navigateMap(int dx, int dy) {
        this.mapOffsetX += dx;
        this.mapOffsetY += dy;
        this.followPlayer = false;
        this.btnPosition.setEnabled(true);
    }

    private void setMapPosition(int x, int z) {
        this.mapOffsetX = (int)((double)(-x) * this.mapScale);
        this.mapOffsetY = (int)((double)(-z) * this.mapScale);
    }

    private void setTargetPosition(int x, int z) {
        this.targetOffsetX = x;
        this.targetOffsetY = z;
    }

    private int getTargetPositionX() {
        return (int)((double)(-this.targetOffsetX.intValue()) * this.mapScale);
    }

    private int getTargetPositionY() {
        return (int)((double)(-this.targetOffsetY.intValue()) * this.mapScale);
    }

    public void setMapScale(double scale) {
        this.setMapScale(scale, 0, 0);
    }

    private void setMapScale(double scale, int addOffsetX, int addOffsetY) {
        double oldScale = this.mapScale;
        this.mapScale = Math.min(Math.max(scale, AntiqueAtlas.CONFIG.minScale), AntiqueAtlas.CONFIG.maxScale);
        if (oldScale == this.mapScale) {
            return;
        }
        if (this.mapScale >= 0.5) {
            this.tileHalfSize = (int)Math.round(8.0 * this.mapScale);
            this.tile2ChunkScale = 1;
        } else {
            this.tileHalfSize = (int)Math.round(4.0);
            this.tile2ChunkScale = (int)Math.round(0.5 / this.mapScale);
        }
        this.scaleBar.setMapScale(this.mapScale * 2.0);
        this.mapOffsetX = (int)((double)(this.mapOffsetX + addOffsetX) * (this.mapScale / oldScale));
        this.mapOffsetY = (int)((double)(this.mapOffsetY + addOffsetY) * (this.mapScale / oldScale));
        this.scaleClipIndex = Mth.log2((int)((int)(this.mapScale * 8192.0))) + 1 - 13;
        this.zoomLevel = -this.scaleClipIndex + 8;
        this.scaleAlpha = 255;
        if (this.followPlayer && (addOffsetX != 0 || addOffsetY != 0)) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
        }
    }

    @Override
    public void render(GuiGraphics matrices, int mouseX, int mouseY, float par3) {
        long currentMillis = System.currentTimeMillis();
        long deltaMillis = currentMillis - this.lastUpdateMillis;
        this.lastUpdateMillis = currentMillis;
        if (AntiqueAtlas.CONFIG.debugRender) {
            this.renderTimes[this.renderTimesIndex++] = System.currentTimeMillis();
            if (this.renderTimesIndex == this.renderTimes.length) {
                this.renderTimesIndex = 0;
                double elapsed = 0.0;
                for (int i = 0; i < this.renderTimes.length - 1; ++i) {
                    elapsed += (double)(this.renderTimes[i + 1] - this.renderTimes[i]);
                }
                System.out.printf("GuiAtlas avg. render time: %.3f\n", elapsed / (double)this.renderTimes.length);
            }
        }
        super.renderBackground(matrices, mouseY, mouseY, par3);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Textures.BOOK.draw(matrices, this.getGuiX(), this.getGuiY());
        if (this.stack == null && AntiqueAtlas.CONFIG.itemNeeded || this.biomeData == null) {
            return;
        }
        if (this.state.is(this.DELETING_MARKER)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        RenderSystem.enableScissor((int)((int)((double)(this.getGuiX() + 17) * this.screenScale)), (int)((int)((double)Minecraft.getInstance().getWindow().getHeight() - (double)(this.getGuiY() + 11 + 194) * this.screenScale)), (int)((int)(276.0 * this.screenScale)), (int)((int)(194.0 * this.screenScale)));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int mapStartX = MathUtil.roundToBase((int)Math.floor(-(138.0 + (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartZ = MathUtil.roundToBase((int)Math.floor(-(97.0 + (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndX = MathUtil.roundToBase((int)Math.ceil((138.0 - (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndZ = MathUtil.roundToBase((int)Math.ceil((97.0 - (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartScreenX = this.getGuiX() + 155 + (int)((double)(mapStartX << 4) * this.mapScale) + this.mapOffsetX;
        int mapStartScreenY = this.getGuiY() + 109 + (int)((double)(mapStartZ << 4) * this.mapScale) + this.mapOffsetY;
        TileRenderIterator tiles = new TileRenderIterator(this.biomeData);
        tiles.setScope(new Rect(mapStartX, mapStartZ, mapEndX, mapEndZ));
        tiles.setStep(this.tile2ChunkScale);
        matrices.pose().pushPose();
        matrices.pose().translate((float)mapStartScreenX, (float)mapStartScreenY, 0.0f);
        for (SubTileQuartet subtiles : tiles) {
            for (SubTile subtile : subtiles) {
                ITexture texture;
                if (subtile == null || subtile.tile == null || !((texture = TileTextureMap.instance().getTexture(subtile)) instanceof TileTexture)) continue;
                TileTexture tileTexture = (TileTexture)texture;
                tileTexture.bind();
                tileTexture.drawSubTile(matrices, subtile, this.tileHalfSize);
            }
        }
        matrices.pose().popPose();
        int markersStartX = MathUtil.roundToBase(mapStartX, 8) / 8 - 1;
        int markersStartZ = MathUtil.roundToBase(mapStartZ, 8) / 8 - 1;
        int markersEndX = MathUtil.roundToBase(mapEndX, 8) / 8 + 1;
        int markersEndZ = MathUtil.roundToBase(mapEndZ, 8) / 8 + 1;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Textures.BOOK_FRAME.draw(matrices, this.getGuiX(), this.getGuiY());
        double iconScale = this.getIconScale();
        this.renderMarkers(matrices, markersStartX, markersStartZ, markersEndX, markersEndZ, this.globalMarkersData);
        this.renderMarkers(matrices, markersStartX, markersStartZ, markersEndX, markersEndZ, this.localMarkersData);
        RenderSystem.disableScissor();
        Textures.BOOK_FRAME_NARROW.draw(matrices, this.getGuiX(), this.getGuiY());
        this.renderScaleOverlay(matrices, deltaMillis);
        if (!this.state.is(this.HIDING_MARKERS)) {
            this.renderPlayer(matrices, iconScale);
        }
        super.render(matrices, mouseX, mouseY, par3);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.state.is(this.PLACING_MARKER)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            this.markerFinalizer.selectedType.calculateMip(iconScale, this.mapScale, this.screenScale);
            MarkerRenderInfo renderInfo = this.markerFinalizer.selectedType.getRenderInfo(iconScale, this.mapScale, this.screenScale);
            this.markerFinalizer.selectedType.resetMip();
            renderInfo.tex.draw(matrices, mouseX + renderInfo.x, mouseY + renderInfo.y);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.disableBlend();
        if (AntiqueAtlas.CONFIG.debugRender && !this.isDragging && this.isMouseOver) {
            int x = this.screenXToWorldX((int)this.getMouseX());
            int z = this.screenYToWorldZ((int)this.getMouseY());
            String coords = String.format("Coords: %d / %d", x, z);
            ChunkPos pos = new ChunkPos(new BlockPos(x, 0, z));
            String chunks = String.format("Chunks: %d / %d", pos.x, pos.z);
            ResourceLocation tile = this.biomeData.getTile(pos.x, pos.z);
            if (tile == null) {
                this.drawTooltip(Arrays.asList(Component.literal((String)coords), Component.literal((String)chunks)), this.font);
            } else {
                String texture_set = TileTextureMap.instance().getTextureSet((ResourceLocation)tile).name.toString();
                this.drawTooltip(Arrays.asList(Component.literal((String)coords), Component.literal((String)chunks), Component.literal((String)("Tile: " + String.valueOf(tile))), Component.literal((String)("TSet: " + texture_set))), this.font);
            }
        }
        if (this.state.is(this.EXPORTING_IMAGE)) {
            this.renderBackground(matrices, mouseX, mouseY, par3);
            this.progressBar.draw(matrices, (this.width - 100) / 2, this.height / 2 - 34);
        }
    }

    private void renderPlayer(GuiGraphics matrices, double iconScale) {
        int playerOffsetX = this.worldXToScreenX(this.player.getBlockX());
        int playerOffsetY = this.worldZToScreenY(this.player.getBlockZ());
        playerOffsetX = Mth.clamp((int)playerOffsetX, (int)(this.getGuiX() + 17), (int)(this.getGuiX() + 276 + 17));
        playerOffsetY = Mth.clamp((int)playerOffsetY, (int)(this.getGuiY() + 11), (int)(this.getGuiY() + 194 + 11));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.state.is(this.PLACING_MARKER) ? 0.5f : 1.0f));
        float playerRotation = (float)Math.round(this.player.getYRot() / 360.0f * 16.0f) / 16.0f * 360.0f;
        Textures.PLAYER.drawCenteredWithRotation(matrices, playerOffsetX, playerOffsetY, (int)Math.round(7.0 * iconScale), (int)Math.round(8.0 * iconScale), playerRotation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderScaleOverlay(GuiGraphics matrices, long deltaMillis) {
        if (this.scaleAlpha > 3) {
            int textWidth;
            matrices.pose().pushPose();
            matrices.pose().translate((float)(this.getGuiX() + 310 - 13), (float)(this.getGuiY() + 12), 0.0f);
            int color = this.scaleAlpha << 24;
            String text = "x";
            int xWidth = textWidth = this.font.width(text);
            ++xWidth;
            matrices.drawString(this.font, text, -textWidth, 0, color);
            text = this.zoomNames[this.zoomLevel];
            if (text.contains("/")) {
                String[] parts = text.split("/");
                int centerXtranslate = Math.max(this.font.width(parts[0]), this.font.width(parts[1])) / 2;
                PoseStack poseStack = matrices.pose();
                float f = -xWidth - centerXtranslate;
                Objects.requireNonNull(this.font);
                poseStack.translate(f, (float)(-9) / 2.0f, 0.0f);
                int n = -centerXtranslate - 1;
                Objects.requireNonNull(this.font);
                Objects.requireNonNull(this.font);
                matrices.fill(n, 9 - 1, centerXtranslate, 9, color);
                textWidth = this.font.width(parts[0]);
                matrices.drawString(this.font, parts[0], -textWidth / 2, 0, color);
                textWidth = this.font.width(parts[1]);
                matrices.drawString(this.font, parts[1], -textWidth / 2, 10, color);
            } else {
                textWidth = this.font.width(text);
                matrices.drawString(this.font, text, -textWidth - xWidth + 1, 2, color);
            }
            matrices.pose().popPose();
            int deltaScaleAlpha = (int)((double)deltaMillis * 0.256);
            if (deltaScaleAlpha == 0) {
                deltaScaleAlpha = 1;
            }
            this.scaleAlpha -= deltaScaleAlpha;
            if (this.scaleAlpha < 0) {
                this.scaleAlpha = 0;
            }
        }
    }

    private void renderMarkers(GuiGraphics matrices, int markersStartX, int markersStartZ, int markersEndX, int markersEndZ, DimensionMarkersData markersData) {
        if (markersData == null) {
            return;
        }
        for (int x = markersStartX; x <= markersEndX; ++x) {
            for (int z = markersStartZ; z <= markersEndZ; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(x, z);
                if (markers == null) continue;
                for (Marker marker : markers) {
                    this.renderMarker(matrices, marker, this.getIconScale());
                }
            }
        }
    }

    private void renderMarker(GuiGraphics matrices, Marker marker, double scale) {
        MarkerType type = (MarkerType)MarkerType.REGISTRY.get(marker.getType());
        if (type.shouldHide(this.state.is(this.HIDING_MARKERS), this.scaleClipIndex)) {
            return;
        }
        int markerX = this.worldXToScreenX(marker.getX());
        int markerY = this.worldZToScreenY(marker.getZ());
        if (!marker.isVisibleAhead() && !this.biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        type.calculateMip(scale, this.mapScale, this.screenScale);
        MarkerRenderInfo info = type.getRenderInfo(scale, this.mapScale, this.screenScale);
        boolean mouseIsOverMarker = type.shouldHover((this.getMouseX() - (double)(markerX + info.x)) / (double)info.tex.width(), (this.getMouseY() - (double)(markerY + info.y)) / (double)info.tex.height());
        type.resetMip();
        if (mouseIsOverMarker) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            this.hoveredMarker = marker;
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hoveredMarker == marker) {
                this.hoveredMarker = null;
            }
        }
        if (this.state.is(this.PLACING_MARKER)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else if (this.state.is(this.DELETING_MARKER) && marker.isGlobal()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (AntiqueAtlas.CONFIG.debugRender) {
            System.out.println("Rendering Marker: " + String.valueOf(info.tex));
        }
        if (!(markerX > this.getGuiX() + 17 && markerX < this.getGuiX() + 276 + 17 && markerY > this.getGuiY() + 11 && markerY < this.getGuiY() + 194 + 11 || type.isTechnical())) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            info.scale(0.8);
        }
        if (!type.isTechnical()) {
            markerX = Mth.clamp((int)markerX, (int)(this.getGuiX() + 17), (int)(this.getGuiX() + 276 + 17));
            markerY = Mth.clamp((int)markerY, (int)(this.getGuiY() + 11), (int)(this.getGuiY() + 194 + 11));
        }
        info.tex.draw(matrices, markerX + info.x, markerY + info.y, info.width, info.height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isMouseOver && mouseIsOverMarker && marker.getLabel().getString().length() > 0) {
            this.drawTooltip(Collections.singletonList(marker.getLabel()), this.font);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void onClose() {
        super.onClose();
        this.markerFinalizer.closeChild();
        this.removeChild(this.blinkingIcon);
        this.biomeData.setBrowsingPosition(this.mapOffsetX, this.mapOffsetY, this.mapScale);
        new PutBrowsingPositionC2SPacket(this.getAtlasID(), (ResourceKey<Level>)this.player.getCommandSenderWorld().dimension(), this.mapOffsetX, this.mapOffsetY, this.mapScale).send();
    }

    private int screenXToWorldX(int mouseX) {
        return (int)Math.round((double)(mouseX - this.width / 2 - this.mapOffsetX) / this.mapScale);
    }

    private int screenYToWorldZ(int mouseY) {
        return (int)Math.round((double)(mouseY - this.height / 2 - this.mapOffsetY) / this.mapScale);
    }

    private int worldXToScreenX(int x) {
        return (int)Math.round((double)x * this.mapScale + (double)((float)this.width / 2.0f) + (double)this.mapOffsetX);
    }

    private int worldZToScreenY(int z) {
        return (int)Math.round((double)z * this.mapScale + (double)((float)this.height / 2.0f) + (double)this.mapOffsetY);
    }

    @Override
    protected void onChildClosed(GuiComponent child) {
        if (((Object)((Object)child)).equals((Object)this.markerFinalizer)) {
            this.setInterceptKeyboard(true);
            this.removeChild(this.blinkingIcon);
        }
    }

    public void updateL18n() {
        this.btnExportPng.setTitle((Component)Component.translatable((String)"gui.antiqueatlas.exportImage"));
        this.btnMarker.setTitle((Component)Component.translatable((String)"gui.antiqueatlas.addMarker"));
    }

    private double getIconScale() {
        if (AntiqueAtlas.CONFIG.doScaleMarkers) {
            if (this.mapScale < 0.5) {
                return 0.5;
            }
            if (this.mapScale > 1.0) {
                return 2.0;
            }
        }
        return 1.0;
    }

    private int getAtlasID() {
        return AntiqueAtlas.CONFIG.itemNeeded ? AtlasItem.getAtlasID(this.stack) : this.player.getUUID().hashCode();
    }
}

