/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.stereowalker.unionlib.util.ScreenHelper;
import hunternif.mc.api.client.AtlasClientAPI;
import hunternif.mc.impl.atlas.client.gui.GuiMarkerInList;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponent;
import hunternif.mc.impl.atlas.client.gui.core.GuiScrollingContainer;
import hunternif.mc.impl.atlas.client.gui.core.ToggleGroup;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class GuiMarkerFinalizer
extends GuiComponent {
    private Level world;
    private int atlasID;
    private int markerX;
    private int markerZ;
    MarkerType selectedType = (MarkerType)MarkerType.REGISTRY.get(MarkerType.REGISTRY.getDefaultKey());
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_SPACING = 4;
    private static final int TYPE_SPACING = 1;
    private static final int TYPE_BG_FRAME = 4;
    private Button btnDone;
    private Button btnCancel;
    private EditBox textField;
    private GuiScrollingContainer scroller;
    private ToggleGroup<GuiMarkerInList> typeRadioGroup;
    private final List<IMarkerTypeSelectListener> markerListeners = new ArrayList<IMarkerTypeSelectListener>();

    GuiMarkerFinalizer() {
    }

    void setMarkerData(Level world, int atlasID, int markerX, int markerZ) {
        this.world = world;
        this.atlasID = atlasID;
        this.markerX = markerX;
        this.markerZ = markerZ;
        this.setBlocksScreen(true);
    }

    void addMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.add(listener);
    }

    void removeMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.remove(listener);
    }

    void removeAllMarkerListeners() {
        this.markerListeners.clear();
    }

    @Override
    public void init() {
        super.init();
        this.btnDone = ScreenHelper.buttonBuilder((Component)Component.translatable((String)"gui.done"), button -> {
            AtlasClientAPI.getMarkerAPI().putMarker(this.world, true, this.atlasID, MarkerType.REGISTRY.getKey((Object)this.selectedType), (Component)Component.literal((String)this.textField.getValue()), this.markerX, this.markerZ);
            Log.info("Put marker in Atlas #%d \"%s\" at (%d, %d)", this.atlasID, this.textField.getValue(), this.markerX, this.markerZ);
            LocalPlayer player = Minecraft.getInstance().player;
            this.world.playSound((Player)player, player.blockPosition(), SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.AMBIENT, 1.0f, 1.0f);
            this.closeChild();
        }).bounds(this.width / 2 - 100 - 2, this.height / 2 + 40, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.btnDone);
        this.btnCancel = ScreenHelper.buttonBuilder((Component)Component.translatable((String)"gui.cancel"), button -> this.closeChild()).bounds(this.width / 2 + 2, this.height / 2 + 40, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.btnCancel);
        this.textField = new EditBox(Minecraft.getInstance().font, (this.width - 200) / 2, this.height / 2 - 81, 200, 20, (Component)Component.translatable((String)"gui.antiqueatlas.marker.label"));
        this.textField.setEditable(true);
        this.textField.setValue("");
        this.addRenderableWidget((GuiEventListener)this.textField);
        this.scroller = new GuiScrollingContainer();
        this.scroller.setWheelScrollsHorizontally();
        this.addChild(this.scroller);
        int typeCount = 0;
        for (MarkerType type : MarkerType.REGISTRY) {
            if (type.isTechnical()) continue;
            ++typeCount;
        }
        int allTypesWidth = typeCount * 35 - 1;
        int scrollerWidth = Math.min(allTypesWidth, 240);
        this.scroller.setViewportSize(scrollerWidth, 35);
        this.scroller.setGuiCoords((this.width - scrollerWidth) / 2, this.height / 2 - 25);
        this.typeRadioGroup = new ToggleGroup();
        this.typeRadioGroup.addListener(button -> {
            this.selectedType = button.getMarkerType();
            for (IMarkerTypeSelectListener listener : this.markerListeners) {
                listener.onSelectMarkerType(button.getMarkerType());
            }
        });
        int contentX = 0;
        for (MarkerType markerType : MarkerType.REGISTRY) {
            if (markerType.isTechnical()) continue;
            GuiMarkerInList markerGui = new GuiMarkerInList(markerType);
            this.typeRadioGroup.addButton(markerGui);
            if (this.selectedType.equals(markerType)) {
                this.typeRadioGroup.setSelectedButton(markerGui);
            }
            this.scroller.addContent(markerGui).setRelativeX(contentX);
            contentX += 35;
        }
    }

    public void setMarkerName(Component name) {
        this.textField.setValue(name.getString());
    }

    @Override
    public void closeChild() {
        super.closeChild();
        if (this.scroller != null) {
            this.scroller.closeChild();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button) || this.textField.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int aa, int bb, int cc) {
        return super.keyPressed(aa, bb, cc) || this.textField.keyPressed(aa, bb, cc);
    }

    @Override
    public boolean charTyped(char aa, int bb) {
        return super.charTyped(aa, bb) || this.textField.charTyped(aa, bb);
    }

    @Override
    public void render(GuiGraphics matrices, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(matrices, mouseY, mouseY, partialTick);
        this.drawCentered(matrices, (Component)Component.translatable((String)"gui.antiqueatlas.marker.label"), this.height / 2 - 97, 0xFFFFFF, true);
        this.textField.render(matrices, mouseX, mouseY, partialTick);
        this.drawCentered(matrices, (Component)Component.translatable((String)"gui.antiqueatlas.marker.type"), this.height / 2 - 44, 0xFFFFFF, true);
        matrices.fillGradient(this.scroller.getGuiX() - 4, this.scroller.getGuiY() - 4, this.scroller.getGuiX() + this.scroller.getWidth() + 4, this.scroller.getGuiY() + this.scroller.getHeight() + 4, -2012213232, -1727000560);
        super.render(matrices, mouseX, mouseY, partialTick);
    }

    static interface IMarkerTypeSelectListener {
        public void onSelectMarkerType(MarkerType var1);
    }
}

