/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import hunternif.mc.impl.atlas.client.gui.ExportUpdateListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

class ProgressBarOverlay {
    private final int barWidth;
    private final int barHeight;
    private final Font textRenderer;

    public ProgressBarOverlay(int barWidth, int barHeight) {
        this.barWidth = barWidth;
        this.barHeight = barHeight;
        this.textRenderer = Minecraft.getInstance().font;
    }

    public void draw(GuiGraphics matrices, int x, int y) {
        ExportUpdateListener l = ExportUpdateListener.INSTANCE;
        int headerWidth = this.textRenderer.width(l.header);
        matrices.drawString(this.textRenderer, l.header, (int)((float)x + (float)(this.barWidth - headerWidth) / 2.0f), y - 14, 0xFFFFFF);
        int statusWidth = this.textRenderer.width(l.status);
        matrices.drawString(this.textRenderer, l.status, (int)((float)x + (float)(this.barWidth - statusWidth) / 2.0f), y, 0xFFFFFF);
        y += 14;
        float p = (float)l.currentProgress / l.maxProgress;
        if (l.maxProgress < 0.0f) {
            p = 0.0f;
        }
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vb = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        vb.addVertex((float)x, (float)y, 0.0f).setColor(0.5f, 0.5f, 0.5f, 1.0f);
        vb.addVertex((float)x, (float)(y + this.barHeight), 0.0f).setColor(0.5f, 0.5f, 0.5f, 1.0f);
        vb.addVertex((float)(x + this.barWidth), (float)(y + this.barHeight), 0.0f).setColor(0.5f, 0.5f, 0.5f, 1.0f);
        vb.addVertex((float)(x + this.barWidth), (float)y, 0.0f).setColor(0.5f, 0.5f, 0.5f, 1.0f);
        vb.addVertex((float)x, (float)y, 0.0f).setColor(0.5f, 1.0f, 0.5f, 1.0f);
        vb.addVertex((float)x, (float)(y + this.barHeight), 0.0f).setColor(0.5f, 1.0f, 0.5f, 1.0f);
        vb.addVertex((float)x + (float)this.barWidth * p, (float)(y + this.barHeight), 0.0f).setColor(0.5f, 1.0f, 0.5f, 1.0f);
        vb.addVertex((float)x + (float)this.barWidth * p, (float)y, 0.0f).setColor(0.5f, 1.0f, 0.5f, 1.0f);
        BufferUploader.drawWithShader((MeshData)vb.buildOrThrow());
    }
}

