/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui.core;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.lwjgl.opengl.GL11;

public class GuiComponent
extends Screen {
    private GuiComponent parent = null;
    private final List<GuiComponent> children = new CopyOnWriteArrayList<GuiComponent>();
    int properWidth;
    int properHeight;
    int contentWidth;
    int contentHeight;
    private boolean sizeIsInvalid = false;
    private boolean isClipped = false;
    protected boolean isMouseOver = false;
    private boolean interceptsMouse = true;
    private boolean interceptsKeyboard = true;
    private boolean blocksScreen = false;
    private int guiX = 0;
    private int guiY = 0;
    private final HoveringTextInfo hoveringTextInfo = new HoveringTextInfo();

    public GuiComponent() {
        super((Component)Component.literal((String)"component"));
    }

    public void setGuiCoords(int x, int y) {
        int dx = x - this.guiX;
        int dy = y - this.guiY;
        this.guiX = x;
        this.guiY = y;
        for (GuiComponent child : this.children) {
            child.offsetGuiCoords(dx, dy);
        }
        if (this.parent != null && (dx != 0 || dy != 0)) {
            this.parent.invalidateSize();
        }
    }

    public final void setRelativeCoords(int x, int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(x, y);
        }
    }

    public final void setRelativeX(int x) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.guiY);
        } else {
            this.setGuiCoords(x, this.guiY);
        }
    }

    public final void setRelativeY(int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.guiX, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(this.guiX, y);
        }
    }

    public final void offsetGuiCoords(int dx, int dy) {
        this.setGuiCoords(this.guiX + dx, this.guiY + dy);
    }

    protected final void setCentered() {
        this.validateSize();
        if (this.parent == null) {
            this.setGuiCoords((this.width - this.getWidth()) / 2, (this.height - this.getHeight()) / 2);
        } else {
            this.setRelativeCoords((this.parent.getWidth() - this.getWidth()) / 2, (this.parent.getHeight() - this.getHeight()) / 2);
        }
    }

    public int getGuiX() {
        return this.guiX;
    }

    public int getGuiY() {
        return this.guiY;
    }

    int getRelativeX() {
        return this.parent == null ? this.guiX : this.guiX - this.parent.guiX;
    }

    int getRelativeY() {
        return this.parent == null ? this.guiY : this.guiY - this.parent.guiY;
    }

    public void setSize(int width, int height) {
        this.properWidth = width;
        this.properHeight = height;
        this.contentWidth = width;
        this.contentHeight = height;
        this.invalidateSize();
    }

    protected GuiComponent addChild(GuiComponent child) {
        this.doAddChild(null, child, null);
        return child;
    }

    public GuiComponent addChildInfrontOf(GuiComponent inFrontOf, GuiComponent child) {
        this.doAddChild(inFrontOf, child, null);
        return child;
    }

    protected GuiComponent addChildBehind(GuiComponent behind, GuiComponent child) {
        this.doAddChild(null, child, behind);
        return child;
    }

    private void doAddChild(GuiComponent inFrontOf, GuiComponent child, GuiComponent behind) {
        if (child == null || this.children.contains((Object)child) || this.parent == child) {
            return;
        }
        int i = this.children.indexOf((Object)inFrontOf);
        if (i == -1) {
            int j = this.children.indexOf((Object)behind);
            if (j == -1) {
                this.children.add(child);
            } else {
                this.children.add(j, child);
            }
        } else {
            this.children.add(i + 1, child);
        }
        child.parent = this;
        child.setGuiCoords(this.guiX, this.guiY);
        if (Minecraft.getInstance() != null) {
            child.init(Minecraft.getInstance(), this.width, this.height);
        }
        this.invalidateSize();
    }

    protected GuiComponent removeChild(GuiComponent child) {
        if (child != null && this.children.contains((Object)child)) {
            child.parent = null;
            this.children.remove((Object)child);
            this.invalidateSize();
            this.onChildClosed(child);
        }
        return child;
    }

    void removeAllChildren() {
        this.children.clear();
        this.invalidateSize();
    }

    public GuiComponent getParent() {
        return this.parent;
    }

    List<GuiComponent> getChildren() {
        return this.children;
    }

    public void setInterceptMouse(boolean value) {
        this.interceptsMouse = value;
    }

    protected void setInterceptKeyboard(boolean value) {
        this.interceptsKeyboard = value;
    }

    protected void setBlocksScreen(boolean value) {
        this.blocksScreen = value;
    }

    boolean iterateInput(UiCall callMethod) {
        ListIterator<GuiComponent> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            GuiComponent child = iter.previous();
            if (!callMethod.call(child)) continue;
            return true;
        }
        return false;
    }

    boolean iterateMouseInput(UiCall callMethod) {
        this.isMouseOver = this.isMouseInRegion(this.getGuiX(), this.getGuiY(), this.getWidth(), this.getHeight());
        if (!this.iterateInput(c -> {
            c.isMouseOver = c.isMouseInRegion(c.getGuiX(), c.getGuiY(), c.getWidth(), c.getHeight());
            return callMethod.call(c);
        })) {
            return false;
        }
        this.isMouseOver = false;
        return true;
    }

    public boolean mouseClicked(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.mouseClicked(mx, my, mb))) {
            return super.mouseClicked(mx, my, mb);
        }
        return true;
    }

    public boolean mouseReleased(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.mouseReleased(mx, my, mb))) {
            return super.mouseReleased(mx, my, mb);
        }
        return true;
    }

    public boolean mouseDragged(double mx, double my, int mb, double mx2, double my2) {
        if (!this.iterateMouseInput(c -> c.mouseDragged(mx, my, mb, mx2, my2))) {
            return super.mouseClicked(mx, my, mb);
        }
        return true;
    }

    public boolean mouseScrolled(double mx, double my, double dy, double partial) {
        if (!this.iterateMouseInput(c -> c.mouseScrolled(mx, my, dy, partial))) {
            return super.mouseScrolled(mx, my, dy, partial);
        }
        return true;
    }

    public void mouseMoved(double mx, double my) {
        if (!this.iterateMouseInput(c -> {
            c.mouseMoved(mx, my);
            return false;
        })) {
            super.mouseMoved(mx, my);
        }
    }

    public boolean keyPressed(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.keyPressed(a, b, c))) {
            return super.keyPressed(a, b, c);
        }
        return true;
    }

    public boolean charTyped(char aa, int bb) {
        if (!this.iterateInput(cpt -> cpt.charTyped(aa, bb))) {
            return super.charTyped(aa, bb);
        }
        return true;
    }

    public boolean keyReleased(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.keyReleased(a, b, c))) {
            return super.keyReleased(a, b, c);
        }
        return true;
    }

    public void render(GuiGraphics matrices, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.renderables) {
            renderable.render(matrices, mouseX, mouseY, partialTick);
        }
        for (GuiComponent child : this.children) {
            if (child.isClipped) continue;
            child.render(matrices, mouseX, mouseY, partialTick);
        }
        if (this.hoveringTextInfo.shouldDraw) {
            this.drawHoveringText2(matrices, this.hoveringTextInfo.lines, this.hoveringTextInfo.x, this.hoveringTextInfo.y, this.hoveringTextInfo.font);
            this.hoveringTextInfo.shouldDraw = false;
        }
    }

    public void onClose() {
        for (GuiComponent child : this.children) {
            child.onClose();
        }
        super.onClose();
    }

    public void tick() {
        for (GuiComponent child : this.children) {
            child.tick();
        }
        super.tick();
        if (this.sizeIsInvalid) {
            this.validateSize();
        }
    }

    public void init() {
        super.init();
        for (GuiComponent child : this.children) {
            child.init(this.minecraft, this.width, this.height);
        }
    }

    protected int getWidth() {
        return this.contentWidth;
    }

    protected int getHeight() {
        return this.contentHeight;
    }

    void setClipped(boolean value) {
        this.isClipped = value;
    }

    private void invalidateSize() {
        this.sizeIsInvalid = true;
        if (this.parent != null) {
            this.parent.invalidateSize();
        }
    }

    void validateSize() {
        int leftmost = Integer.MAX_VALUE;
        int rightmost = Integer.MIN_VALUE;
        int topmost = Integer.MAX_VALUE;
        int bottommost = Integer.MIN_VALUE;
        for (GuiComponent child : this.children) {
            int childHeight;
            int y;
            int childWidth;
            int x = child.getGuiX();
            if (x < leftmost) {
                leftmost = x;
            }
            if (x + (childWidth = child.getWidth()) > rightmost) {
                rightmost = x + childWidth;
            }
            if ((y = child.getGuiY()) < topmost) {
                topmost = y;
            }
            if (y + (childHeight = child.getHeight()) <= bottommost) continue;
            bottommost = y + childHeight;
        }
        this.contentWidth = Math.max(this.properWidth, rightmost - leftmost);
        this.contentHeight = Math.max(this.properHeight, bottommost - topmost);
        this.sizeIsInvalid = false;
    }

    boolean isMouseInRegion(int left, int top, int width, int height) {
        double mouseX = this.getMouseX();
        double mouseY = this.getMouseY();
        return mouseX >= (double)left && mouseX < (double)(left + width) && mouseY >= (double)top && mouseY < (double)(top + height);
    }

    protected boolean isMouseInRadius(int x, int y, int radius) {
        double mouseX = this.getMouseX();
        double mouseY = this.getMouseY();
        return mouseX >= (double)(x - radius) && mouseX < (double)(x + radius) && mouseY >= (double)(y - radius) && mouseY < (double)(y + radius);
    }

    private void drawHoveringText2(GuiGraphics matrices, List<Component> lines, double x, double y, Font font) {
        boolean stencilEnabled = GL11.glIsEnabled((int)2960);
        if (stencilEnabled) {
            GL11.glDisable((int)2960);
        }
        Font old = this.font;
        this.font = font;
        matrices.renderComponentTooltip(font, lines, (int)x, (int)y);
        this.font = old;
        if (stencilEnabled) {
            GL11.glEnable((int)2960);
        }
    }

    private GuiComponent getTopLevelParent() {
        GuiComponent component = this;
        while (component.parent != null) {
            component = component.parent;
        }
        return component;
    }

    protected void drawTooltip(List<Component> lines, Font font) {
        GuiComponent topLevel = this.getTopLevelParent();
        topLevel.hoveringTextInfo.lines = lines;
        topLevel.hoveringTextInfo.x = this.getMouseX();
        topLevel.hoveringTextInfo.y = this.getMouseY();
        topLevel.hoveringTextInfo.font = font;
        topLevel.hoveringTextInfo.shouldDraw = true;
    }

    public void closeChild() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else {
            Minecraft.getInstance().setScreen(null);
        }
    }

    protected void onChildClosed(GuiComponent child) {
    }

    protected void drawCentered(GuiGraphics matrices, Component text, int y, int color, boolean dropShadow) {
        int length = this.font.width((FormattedText)text);
        matrices.drawString(this.font, text, (this.width - length) / 2, y, color, dropShadow);
    }

    protected double getMouseX() {
        return Minecraft.getInstance().mouseHandler.xpos() * (double)this.width / (double)Minecraft.getInstance().getWindow().getScreenWidth();
    }

    protected double getMouseY() {
        return Minecraft.getInstance().mouseHandler.ypos() * (double)this.height / (double)Minecraft.getInstance().getWindow().getScreenHeight();
    }

    private static class HoveringTextInfo {
        List<Component> lines;
        double x;
        double y;
        Font font;
        boolean shouldDraw = false;

        private HoveringTextInfo() {
        }
    }

    @FunctionalInterface
    static interface UiCall {
        public boolean call(GuiComponent var1);
    }
}

