/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui.core;

import hunternif.mc.impl.atlas.client.gui.core.GuiComponent;
import hunternif.mc.impl.atlas.client.gui.core.IButtonListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class GuiComponentButton
extends GuiComponent {
    private final List<IButtonListener> listeners = new ArrayList<IButtonListener>();
    private boolean enabled = true;
    private SoundEvent clickSound = (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value();

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setClickSound(SoundEvent clickSound) {
        this.clickSound = clickSound;
    }

    public void mute() {
        this.clickSound = null;
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (mouseButton == 0 && this.enabled && this.isMouseOver) {
            this.onClick();
            return true;
        }
        return super.mouseClicked(x, y, mouseButton);
    }

    void onClick() {
        if (this.clickSound != null) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.clickSound, (float)1.0f));
        }
        for (IButtonListener listener : this.listeners) {
            listener.onClick(this);
        }
    }

    public void addListener(IButtonListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IButtonListener listener) {
        this.listeners.remove(listener);
    }
}

