/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public abstract class ATexture
implements ITexture {
    final ResourceLocation texture;
    final boolean autobind;
    private final RenderType LAYER;

    public ATexture(ResourceLocation texture) {
        this(texture, true);
    }

    public ATexture(ResourceLocation texture, boolean autobind) {
        this.texture = texture;
        this.autobind = autobind;
        this.LAYER = RenderType.text((ResourceLocation)texture);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
    }

    @Override
    public void draw(GuiGraphics matrices, int x, int y) {
        this.draw(matrices, x, y, this.width(), this.height());
    }

    @Override
    public void draw(GuiGraphics matrices, int x, int y, int width, int height) {
        this.draw(matrices, x, y, width, height, 0, 0, this.width(), this.height());
    }

    @Override
    public void draw(GuiGraphics matrices, int x, int y, int u, int v, int regionWidth, int regionHeight) {
        this.draw(matrices, x, y, regionWidth, regionHeight, u, v, regionWidth, regionHeight);
    }

    @Override
    public void draw(GuiGraphics matrices, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight) {
        if (this.autobind) {
            this.bind();
        }
        matrices.blit(this.texture, x, y, width, height, (float)u, (float)v, regionWidth, regionHeight, this.width(), this.height());
    }

    @Override
    public void drawCenteredWithRotation(GuiGraphics matrices, int x, int y, int width, int height, float rotation) {
        matrices.pose().pushPose();
        matrices.pose().translate((float)x, (float)y, 0.0f);
        matrices.pose().mulPose(Axis.ZP.rotationDegrees(180.0f + rotation));
        matrices.pose().translate((float)(-width) / 2.0f, (float)(-height) / 2.0f, 0.0f);
        this.draw(matrices, 0, 0, width, height);
        matrices.pose().popPose();
    }

    @Override
    public void drawWithLight(MultiBufferSource consumer, PoseStack matrices, int x, int y, int width, int height, int light) {
        this.drawWithLight(consumer, matrices, x, y, width, height, 0, 0, this.width(), this.height(), light);
    }

    @Override
    public void drawWithLight(MultiBufferSource consumer, PoseStack matrices, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int light) {
        if (this.autobind) {
            this.bind();
        }
        this.drawTexturedQuadWithLight(consumer, matrices.last().pose(), x, x + width, y, y + height, ((float)u + 0.0f) / (float)this.width(), ((float)u + (float)regionWidth) / (float)this.width(), ((float)v + 0.0f) / (float)this.height(), ((float)v + (float)regionHeight) / (float)this.height(), light);
    }

    private void drawTexturedQuadWithLight(MultiBufferSource vertexConsumer, Matrix4f matrices, int x0, int x1, int y0, int y1, float u0, float u1, float v0, float v1, int light) {
        VertexConsumer consumer = vertexConsumer.getBuffer(this.LAYER);
        consumer.addVertex(matrices, (float)x0, (float)y1, 0.0f).setColor(255, 255, 255, 255).setUv(u0, v1).setLight(light);
        consumer.addVertex(matrices, (float)x1, (float)y1, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v1).setLight(light);
        consumer.addVertex(matrices, (float)x1, (float)y0, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v0).setLight(light);
        consumer.addVertex(matrices, (float)x0, (float)y0, 0.0f).setColor(255, 255, 255, 255).setUv(u0, v0).setLight(light);
    }
}

