/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.item.AtlasItem;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class TileDataHandler {
    private static final String ATLAS_DATA_PREFIX = "aAtlas_";
    private final Map<String, AtlasData> atlasDataClientCache = new ConcurrentHashMap<String, AtlasData>();

    public AtlasData getData(ItemStack stack, Level world) {
        if (stack.getItem() instanceof AtlasItem) {
            return this.getData(AtlasItem.getAtlasID(stack), world);
        }
        return null;
    }

    public AtlasData getData(int atlasID, Level world) {
        String key = this.getAtlasDataKey(atlasID);
        if (world.isClientSide) {
            return this.atlasDataClientCache.computeIfAbsent(key, s -> new AtlasData());
        }
        DimensionDataStorage manager = ((ServerLevel)world).getDataStorage();
        return (AtlasData)manager.computeIfAbsent(new SavedData.Factory(AtlasData::new, AtlasData::fromNbt, null), key);
    }

    private String getAtlasDataKey(int atlasID) {
        return ATLAS_DATA_PREFIX + atlasID;
    }

    public void onClientConnectedToServer(boolean isRemote) {
        this.atlasDataClientCache.clear();
    }
}

