/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.core.TileIdMap;
import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import hunternif.mc.impl.atlas.core.scaning.TileHeightType;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;

public class TileDetectorBase
implements ITileDetector {
    private static final ResourceLocation waterPoolBiome = Biomes.RIVER.location();
    private static final int priorityRavine = 12;
    private static final int priorityWaterPool = 4;
    private static final int priorityLavaPool = 6;
    private static final int ravineMinDepth = 7;
    private static final Set<ResourceLocation> waterBiomes = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> beachBiomes = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> swampBiomes = new HashSet<ResourceLocation>();

    public static void scanBiomeTypes(Level level) {
        beachBiomes.clear();
        waterBiomes.clear();
        swampBiomes.clear();
        level.registryAccess().registryOrThrow(Registries.BIOME).holders().forEach(biome -> {
            if (biome.is(BiomeTags.IS_BEACH)) {
                beachBiomes.add(biome.key().location());
            }
            if (biome.is(BiomeTags.IS_RIVER)) {
                waterBiomes.add(biome.key().location());
            }
            if (biome.is(BiomeTags.IS_OCEAN)) {
                waterBiomes.add(biome.key().location());
            }
            if (biome.is(BiomeTags.HAS_RUINED_PORTAL_SWAMP)) {
                swampBiomes.add(biome.key().location());
            }
        });
    }

    int priorityForBiome(ResourceLocation biome) {
        if (waterBiomes.contains(biome)) {
            return 4;
        }
        if (beachBiomes.contains(biome)) {
            return 3;
        }
        return 1;
    }

    protected static TileHeightType getHeightTypeFromY(int y, int sealevel) {
        if (y < sealevel + 10) {
            return TileHeightType.VALLEY;
        }
        if (y < sealevel + 20) {
            return TileHeightType.LOW;
        }
        if (y < sealevel + 35) {
            return TileHeightType.MID;
        }
        if (y < sealevel + 50) {
            return TileHeightType.HIGH;
        }
        return TileHeightType.PEAK;
    }

    protected static ResourceLocation getBiomeIdentifier(Level world, Biome biome) {
        return world.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
    }

    protected static void updateOccurrencesMap(Map<ResourceLocation, Integer> map, ResourceLocation biome, int weight) {
        int occurrence = map.getOrDefault(biome, 0) + weight;
        map.put(biome, occurrence);
    }

    protected static void updateOccurrencesMap(Map<ResourceLocation, Integer> map, Level world, Biome biome, TileHeightType type, int weight) {
        ResourceLocation id = TileDetectorBase.getBiomeIdentifier(world, biome);
        id = ResourceLocation.tryParse((String)(id.toString() + "_" + type.getName()));
        int occurrence = map.getOrDefault(id, 0) + weight;
        map.put(id, occurrence);
    }

    @Override
    public int getScanRadius() {
        return AntiqueAtlas.CONFIG.scanRadius;
    }

    @Override
    public ResourceLocation getBiomeID(Level world, ChunkAccess chunk) {
        HashMap<ResourceLocation, Integer> biomeOccurrences = new HashMap<ResourceLocation, Integer>(world.registryAccess().registryOrThrow(Registries.BIOME).keySet().size());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = (Biome)chunk.getNoiseBiome(x, world.getSeaLevel(), z).value();
                int y = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.MOTION_BLOCKING).getFirstAvailable(x, z);
                if (AntiqueAtlas.CONFIG.doScanPonds && y > 0) {
                    Block topBlock = chunk.getBlockState(new BlockPos(x, y - 1, z)).getBlock();
                    if (topBlock == Blocks.WATER) {
                        if (swampBiomes.contains(TileDetectorBase.getBiomeIdentifier(world, biome))) {
                            TileDetectorBase.updateOccurrencesMap(biomeOccurrences, TileIdMap.SWAMP_WATER, 4);
                        } else {
                            TileDetectorBase.updateOccurrencesMap(biomeOccurrences, waterPoolBiome, 4);
                        }
                    } else if (topBlock == Blocks.LAVA) {
                        TileDetectorBase.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_LAVA, 6);
                    }
                }
                if (AntiqueAtlas.CONFIG.doScanRavines && y > 0 && y < world.getSeaLevel() - 7) {
                    TileDetectorBase.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_RAVINE, 12);
                }
                TileDetectorBase.updateOccurrencesMap(biomeOccurrences, world, biome, TileDetectorBase.getHeightTypeFromY(y, world.getSeaLevel()), this.priorityForBiome(TileDetectorBase.getBiomeIdentifier(world, biome)));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (ResourceLocation)meanBiome.getKey();
    }
}

