/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorBase;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;

public class TileDetectorEnd
extends TileDetectorBase
implements ITileDetector {
    @Override
    public ResourceLocation getBiomeID(Level world, ChunkAccess chunk) {
        HashMap<ResourceLocation, Integer> biomeOccurrences = new HashMap<ResourceLocation, Integer>(world.registryAccess().registryOrThrow(Registries.BIOME).keySet().size());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = (Biome)chunk.getNoiseBiome(x, 0, z).value();
                ResourceLocation id = TileDetectorEnd.getBiomeIdentifier(world, biome);
                if (id == Biomes.THE_VOID.location()) {
                    TileDetectorEnd.updateOccurrencesMap(biomeOccurrences, id, 1);
                    continue;
                }
                int top = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE).getFirstAvailable(x, z);
                BlockState topBlock = chunk.getBlockState(new BlockPos(x, top - 1, z));
                if (topBlock.getBlock() == Blocks.END_STONE) {
                    TileDetectorEnd.updateOccurrencesMap(biomeOccurrences, TileDetectorEnd.getBiomeIdentifier(world, biome), 3);
                    continue;
                }
                if (!topBlock.isAir()) continue;
                TileDetectorEnd.updateOccurrencesMap(biomeOccurrences, Biomes.THE_VOID.location(), 1);
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (ResourceLocation)meanBiome.getKey();
    }
}

