/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorBase;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorEnd;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorNether;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class WorldScanner {
    private final Map<ResourceKey<Level>, ITileDetector> biomeAnalyzers = new HashMap<ResourceKey<Level>, ITileDetector>();
    private final TileDetectorBase tileDetectorOverworld = new TileDetectorBase();

    public WorldScanner() {
        this.setBiomeDetectorForWorld((ResourceKey<Level>)Level.OVERWORLD, this.tileDetectorOverworld);
        this.setBiomeDetectorForWorld((ResourceKey<Level>)Level.NETHER, new TileDetectorNether());
        this.setBiomeDetectorForWorld((ResourceKey<Level>)Level.END, new TileDetectorEnd());
    }

    private ITileDetector getBiomeDetectorForWorld(ResourceKey<Level> world) {
        ITileDetector biomeAnalyzer = this.biomeAnalyzers.get(world);
        return biomeAnalyzer == null ? this.tileDetectorOverworld : biomeAnalyzer;
    }

    private void setBiomeDetectorForWorld(ResourceKey<Level> world, ITileDetector biomeAnalyzer) {
        this.biomeAnalyzers.put(world, biomeAnalyzer);
    }

    public Collection<TileInfo> updateAtlasAroundPlayer(AtlasData data, Player player) {
        int newScanInterval = Math.round(AntiqueAtlas.CONFIG.newScanInterval * 20.0f);
        if (player.getCommandSenderWorld().getGameTime() % (long)newScanInterval != 0L) {
            return Collections.emptyList();
        }
        ArrayList<TileInfo> updatedTiles = new ArrayList<TileInfo>();
        int rescanInterval = newScanInterval * AntiqueAtlas.CONFIG.rescanRate;
        boolean rescanRequired = AntiqueAtlas.CONFIG.doRescan && player.getCommandSenderWorld().getGameTime() % (long)rescanInterval == 0L;
        ITileDetector biomeDetector = this.getBiomeDetectorForWorld((ResourceKey<Level>)player.getCommandSenderWorld().dimension());
        int scanRadius = biomeDetector.getScanRadius();
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                if (dx * dx + dz * dz > scanRadius * scanRadius) continue;
                int chunkX = player.chunkPosition().x + dx;
                int chunkZ = player.chunkPosition().z + dz;
                TileInfo update = this.updateAtlasForChunk(data, player.getCommandSenderWorld(), chunkX, chunkZ, rescanRequired);
                if (update == null) continue;
                updatedTiles.add(update);
            }
        }
        return updatedTiles;
    }

    private TileInfo updateAtlasForChunk(AtlasData data, Level world, int x, int z, boolean rescanRequired) {
        WorldData storedData = data.getWorldData((ResourceKey<Level>)world.dimension());
        ResourceLocation oldTile = storedData.getTile(x, z);
        ResourceLocation tile = AtlasAPI.getTileAPI().getGlobalTile(world, x, z);
        if (tile == null) {
            if (oldTile != null && !rescanRequired) {
                return null;
            }
            if (!world.getChunkSource().hasChunk(x, z)) {
                return null;
            }
            ChunkAccess chunk = world.getChunk(x, z, ChunkStatus.FULL, AntiqueAtlas.CONFIG.forceChunkLoading);
            if (chunk == null) {
                return null;
            }
            ITileDetector biomeDetector = this.getBiomeDetectorForWorld((ResourceKey<Level>)world.dimension());
            tile = biomeDetector.getBiomeID(world, chunk);
            if (oldTile != null) {
                if (tile == null) {
                    data.removeTile((ResourceKey<Level>)world.dimension(), x, z);
                } else if (!oldTile.equals((Object)tile)) {
                    data.setTile((ResourceKey<Level>)world.dimension(), x, z, tile);
                    return new TileInfo(x, z, tile);
                }
            } else if (tile != null) {
                data.setTile((ResourceKey<Level>)world.dimension(), x, z, tile);
                return new TileInfo(x, z, tile);
            }
        } else if (oldTile == null || !oldTile.equals((Object)tile)) {
            data.setTile((ResourceKey<Level>)world.dimension(), x, z, tile);
            data.setDirty();
            return new TileInfo(x, z, tile);
        }
        return null;
    }
}

