/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.item;

import com.mojang.serialization.Codec;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.util.VersionHelper;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.item.EmptyAtlasItem;
import hunternif.mc.impl.atlas.item.RecipeAtlasCloning;
import hunternif.mc.impl.atlas.item.RecipeAtlasCombining;
import io.netty.buffer.ByteBuf;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class AntiqueAtlasItems {
    public static ItemStack getAtlasFromId(int atlasID) {
        ItemStack atlas = new ItemStack((ItemLike)Items.ATLAS);
        Components.ATLAS_ID_DATA.setData(atlas, (Object)new AtlasId(atlasID));
        return atlas;
    }

    public static void register() {
        if (AntiqueAtlas.CONFIG.itemNeeded) {
            // empty if block
        }
    }

    @RegistryHolder(namespace="antiqueatlas")
    public class Items {
        @RegistryObject(value="empty_antique_atlas")
        public static final Item EMPTY_ATLAS = new EmptyAtlasItem(new Item.Properties());
        @RegistryObject(value="antique_atlas")
        public static final Item ATLAS = new AtlasItem(new Item.Properties().stacksTo(1));

        public Items(AntiqueAtlasItems this$0) {
        }
    }

    @RegistryHolder(namespace="antiqueatlas")
    public class Components {
        @RegistryObject(value="atlas_id")
        public static final DataComponentType<AtlasId> ATLAS_ID = Components.register(type -> type.persistent(AtlasId.CODEC).networkSynchronized(AtlasId.STREAM_CODEC));
        public static final VersionHelper.Data<AtlasId> ATLAS_ID_DATA = new VersionHelper.Data(stack -> stack.has(ATLAS_ID), stack -> (AtlasId)stack.get(ATLAS_ID), (stack, dat) -> stack.set(ATLAS_ID, dat), stack -> stack.remove(ATLAS_ID));

        public Components(AntiqueAtlasItems this$0) {
        }

        private static <T> DataComponentType<T> register(UnaryOperator<DataComponentType.Builder<T>> pBuilder) {
            return ((DataComponentType.Builder)pBuilder.apply(DataComponentType.builder())).build();
        }
    }

    public record AtlasId(int id) {
        public static final Codec<AtlasId> CODEC = Codec.INT.xmap(AtlasId::new, AtlasId::id);
        public static final StreamCodec<ByteBuf, AtlasId> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(AtlasId::new, AtlasId::id);

        public String key() {
            return "atlas_" + this.id;
        }
    }

    @RegistryHolder(namespace="antiqueatlas")
    public class Recipes {
        @RegistryObject(value="atlas_clone")
        public static final RecipeSerializer<?> CLONE = new SimpleCraftingRecipeSerializer(RecipeAtlasCloning::new);
        @RegistryObject(value="atlas_combine")
        public static final RecipeSerializer<RecipeAtlasCombining> COMBINE = new SimpleCraftingRecipeSerializer(RecipeAtlasCombining::new);

        public Recipes(AntiqueAtlasItems this$0) {
        }
    }
}

