/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.item;

import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.AntiqueAtlasClientSegment;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.item.AntiqueAtlasItems;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.packet.s2c.play.DimensionUpdateS2CPacket;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapBanner;

public class AtlasItem
extends Item {
    public AtlasItem(Item.Properties settings) {
        super(settings);
    }

    public static int getAtlasID(ItemStack stack) {
        if (AntiqueAtlasItems.Components.ATLAS_ID_DATA.hasData(stack)) {
            return ((AntiqueAtlasItems.AtlasId)AntiqueAtlasItems.Components.ATLAS_ID_DATA.getData(stack)).id();
        }
        return 0;
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{AtlasItem.getAtlasID(stack)});
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player playerEntity, InteractionHand hand) {
        ItemStack stack = playerEntity.getItemInHand(hand);
        if (world.isClientSide) {
            AntiqueAtlasClientSegment.openAtlasGUI(stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide()) {
            return super.useOn(context);
        }
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (blockState.is(BlockTags.BANNERS)) {
            AntiqueAtlasClientSegment.openAtlasGUI(context.getItemInHand());
            MapBanner mapBannerMarker = MapBanner.fromWorld((BlockGetter)context.getLevel(), (BlockPos)context.getClickedPos());
            AntiqueAtlasClientSegment.getAtlasGUI().openMarkerFinalizer((Component)mapBannerMarker.name().get());
            context.getLevel().playSound(context.getPlayer(), context.getClickedPos(), SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean isEquipped) {
        Collection<TileInfo> newTiles;
        AtlasData data = AntiqueAtlas.tileData.getData(stack, world);
        if (data == null || !(entity instanceof Player)) {
            return;
        }
        int atlasId = AtlasItem.getAtlasID(stack);
        Player player = (Player)entity;
        if (!(world.isClientSide || data.isSyncedToPlayer(player) || data.isEmpty())) {
            data.syncToPlayer(atlasId, player);
        }
        MarkersData markers = AntiqueAtlas.markersData.getMarkersData(stack, world);
        if (!(world.isClientSide || markers.isSyncedOnPlayer(player) || markers.isEmpty())) {
            markers.syncToPlayer(atlasId, (ServerPlayer)player);
        }
        if (!world.isClientSide && !(newTiles = AntiqueAtlas.worldScanner.updateAtlasAroundPlayer(data, player)).isEmpty()) {
            new DimensionUpdateS2CPacket(atlasId, (ResourceKey<Level>)player.getCommandSenderWorld().dimension(), newTiles).send(Objects.requireNonNull(player.getServer()));
        }
    }
}

