/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.item;

import hunternif.mc.impl.atlas.item.AntiqueAtlasItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeAtlasCloning
implements CraftingRecipe {
    public RecipeAtlasCloning(CraftingBookCategory craftingBookCategory) {
    }

    public String getGroup() {
        return "antiqueatlas:atlas";
    }

    public boolean matches(CraftingInput inv, Level world) {
        int i = 0;
        ItemStack filledAtlas = ItemStack.EMPTY;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack stack = inv.getItem(j);
            if (stack.isEmpty()) continue;
            if (stack.getItem() == AntiqueAtlasItems.Items.ATLAS) {
                if (!filledAtlas.isEmpty()) {
                    return false;
                }
                filledAtlas = stack;
                continue;
            }
            if (stack.getItem() != AntiqueAtlasItems.Items.EMPTY_ATLAS) {
                return false;
            }
            ++i;
        }
        return !filledAtlas.isEmpty() && i > 0;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        int i = 0;
        ItemStack filledAtlas = ItemStack.EMPTY;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack stack = inv.getItem(j);
            if (stack.isEmpty()) continue;
            if (stack.getItem() == AntiqueAtlasItems.Items.ATLAS) {
                if (!filledAtlas.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                filledAtlas = stack;
                continue;
            }
            if (stack.getItem() != AntiqueAtlasItems.Items.EMPTY_ATLAS) {
                return ItemStack.EMPTY;
            }
            ++i;
        }
        if (!filledAtlas.isEmpty() && i >= 1) {
            ItemStack newAtlas = new ItemStack((ItemLike)AntiqueAtlasItems.Items.ATLAS, i + 1);
            AntiqueAtlasItems.Components.ATLAS_ID_DATA.setData(newAtlas, (Object)((AntiqueAtlasItems.AtlasId)AntiqueAtlasItems.Components.ATLAS_ID_DATA.getData(filledAtlas)));
            if (filledAtlas.has(DataComponents.CUSTOM_NAME)) {
                newAtlas.set(DataComponents.CUSTOM_NAME, (Object)((Component)filledAtlas.get(DataComponents.CUSTOM_NAME)));
            }
            return newAtlas;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public RecipeSerializer<?> getSerializer() {
        return AntiqueAtlasItems.Recipes.CLONE;
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }
}

