/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.item;

import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.item.AntiqueAtlasItems;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeAtlasCombining
implements CraftingRecipe {
    public RecipeAtlasCombining(CraftingBookCategory craftingBookCategory) {
    }

    public String getGroup() {
        return "antiqueatlas:atlas_combine";
    }

    public boolean matches(CraftingInput inv, Level world) {
        return this.matches(inv);
    }

    private boolean matches(CraftingInput inv) {
        int atlasesFound = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || stack.getItem() != AntiqueAtlasItems.Items.ATLAS) continue;
            ++atlasesFound;
        }
        return atlasesFound > 1;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack firstAtlas = ItemStack.EMPTY;
        ArrayList<Integer> atlasIds = new ArrayList<Integer>(9);
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof AtlasItem)) continue;
            if (firstAtlas.isEmpty()) {
                firstAtlas = stack;
                continue;
            }
            atlasIds.add(AtlasItem.getAtlasID(stack));
        }
        return atlasIds.size() < 1 ? ItemStack.EMPTY : firstAtlas.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)AntiqueAtlasItems.Items.ATLAS);
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public RecipeSerializer<?> getSerializer() {
        return AntiqueAtlasItems.Recipes.COMBINE;
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public ItemStack onCrafted(Level world, Container inventory, ItemStack result) {
        if (world.isClientSide) {
            return result;
        }
        int atlasID = AntiqueAtlas.getAtlasIdData(world).getNextAtlasId();
        AtlasData destBiomes = AntiqueAtlas.tileData.getData(atlasID, world);
        destBiomes.setDirty();
        MarkersData destMarkers = AntiqueAtlas.markersData.getMarkersData(atlasID, world);
        destMarkers.setDirty();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            AtlasData srcBiomes = AntiqueAtlas.tileData.getData(stack, world);
            if (destBiomes != null && srcBiomes != null && destBiomes != srcBiomes) {
                for (ResourceKey<Level> worldRegistryKey : srcBiomes.getVisitedWorlds()) {
                    destBiomes.getWorldData(worldRegistryKey).addData(srcBiomes.getWorldData(worldRegistryKey));
                }
            }
            MarkersData srcMarkers = AntiqueAtlas.markersData.getMarkersData(stack, world);
            if (destMarkers == null || srcMarkers == null || destMarkers == srcMarkers) continue;
            for (ResourceKey<Level> worldRegistryKey : srcMarkers.getVisitedDimensions()) {
                for (Marker marker : srcMarkers.getMarkersDataInWorld(worldRegistryKey).getAllMarkers()) {
                    destMarkers.createAndSaveMarker(marker.getType(), worldRegistryKey, marker.getX(), marker.getZ(), marker.isVisibleAhead(), marker.getLabel());
                }
            }
        }
        AntiqueAtlasItems.Components.ATLAS_ID_DATA.setData(result, (Object)new AntiqueAtlasItems.AtlasId(atlasID));
        return result;
    }
}

