/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class GlobalMarkersDataHandler {
    private static final String DATA_KEY = "aAtlasGlobalMarkers";
    private GlobalMarkersData data;

    public void onWorldLoad(ServerLevel world) {
        if (world.dimension() == Level.OVERWORLD) {
            this.data = (GlobalMarkersData)world.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> {
                GlobalMarkersData data = new GlobalMarkersData();
                data.setDirty();
                return data;
            }, GlobalMarkersData::readNbt, null), DATA_KEY);
        }
    }

    public void onClientConnectedToServer(boolean isRemote) {
        if (isRemote) {
            this.data = null;
        }
    }

    public GlobalMarkersData getData() {
        if (this.data == null) {
            this.data = new GlobalMarkersData();
        }
        return this.data;
    }

    public void onPlayerLogin(ServerPlayer player) {
        this.data.syncOnPlayer(player);
    }
}

