/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class MarkerTextureConfig
implements ResourceReloadListener<Map<ResourceLocation, MarkerType>>,
ReloadListener {
    public static final ResourceLocation ID = AntiqueAtlas.id("markers");
    private static final int VERSION = 1;
    private static final JsonParser parser = new JsonParser();

    @Override
    public CompletableFuture<Map<ResourceLocation, MarkerType>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, MarkerType> typeMap = new HashMap<ResourceLocation, MarkerType>();
            for (Map.Entry id : manager.listResources("atlas/markers", s -> s.toString().endsWith(".json")).entrySet()) {
                ResourceLocation markerId = VersionHelper.toLoc((String)((ResourceLocation)id.getKey()).getNamespace(), (String)((ResourceLocation)id.getKey()).getPath().replace("atlas/markers/", "").replace(".json", ""));
                try {
                    Resource resource = (Resource)id.getValue();
                    InputStream stream = resource.open();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = parser.parse((Reader)reader).getAsJsonObject();
                        int version = object.getAsJsonPrimitive("version").getAsInt();
                        if (version != 1) {
                            throw new RuntimeException("Incompatible version (1 != " + version + ")");
                        }
                        MarkerType markerType = new MarkerType(markerId);
                        markerType.getJSONData().readFrom(object);
                        markerType.setIsFromJson(true);
                        typeMap.put(markerId, markerType);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    AntiqueAtlas.LOG.warn("Error reading marker " + String.valueOf(markerId) + "!", (Throwable)e);
                }
            }
            return typeMap;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, MarkerType> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : data.entrySet()) {
                MarkerType.register((ResourceLocation)entry.getKey(), (MarkerType)entry.getValue());
            }
        }, executor);
    }

    @Override
    public String getName() {
        return ID.toString();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }
}

