/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlas;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.mixinhooks.EntityHooksAA;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public class NetherPortalWatcher {
    private final Map<Integer, DimensionType> teleportingPlayersOrigin = new ConcurrentHashMap<Integer, DimensionType>();

    private void addPortalMarkerIfNone(Player player) {
        if (!AntiqueAtlas.CONFIG.autoNetherPortalMarkers || player.getCommandSenderWorld().isClientSide) {
            return;
        }
        Level world = player.getCommandSenderWorld();
        if (!AntiqueAtlas.CONFIG.itemNeeded) {
            this.addPortalMarkerIfNone(player, world, player.getUUID().hashCode());
            return;
        }
        for (ItemStack stack : player.getInventory().items) {
            if (stack == null || !(stack.getItem() instanceof AtlasItem)) continue;
            this.addPortalMarkerIfNone(player, world, AtlasItem.getAtlasID(stack));
        }
    }

    private void addPortalMarkerIfNone(Player player, Level world, int atlasID) {
        int z;
        int x;
        MarkerType netherPortalType = (MarkerType)MarkerType.REGISTRY.get(AntiqueAtlas.id("nether_portal"));
        if (netherPortalType == null) {
            return;
        }
        DimensionMarkersData data = AntiqueAtlas.markersData.getMarkersData(atlasID, world).getMarkersDataInWorld((ResourceKey<Level>)world.dimension());
        List<Marker> markers = data.getMarkersAtChunk(((x = (int)player.getX()) >> 4) / 8, ((z = (int)player.getZ()) >> 4) / 8);
        if (markers != null) {
            for (Marker marker : markers) {
                if (!marker.getType().equals((Object)"antiqueatlas:nether_portal")) continue;
                return;
            }
        }
        AtlasAPI.getMarkerAPI().putMarker(world, false, atlasID, MarkerType.REGISTRY.getKey((Object)netherPortalType), (Component)Component.translatable((String)"gui.antiqueatlas.marker.netherPortal"), x, z);
    }

    private static boolean isEntityInPortal(Entity entity) {
        return ((EntityHooksAA)entity).antiqueAtlas_isInPortal();
    }
}

